/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.Batch;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.BatchActionBlock;
import com.excentis.products.byteblower.model.TimedStartType;
import com.excentis.products.byteblower.model.control.BatchActionBlockController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.RealTimeCommand;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.Calendar;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;

class RealTimeSortBatchActionBlocksCommand
extends RealTimeCommand {
    private final Batch batch;
    private boolean sorted = false;

    RealTimeSortBatchActionBlocksCommand(Batch batch) {
        this.batch = batch;
    }

    @Override
    protected void createCompound() {
        boolean relativeStart = this.batch.getStartType() == TimedStartType.RELATIVE;
        BasicEList localCopy = new BasicEList((Collection)this.batch.getBatchActionBlocks());
        block0: while (!this.sorted) {
            BatchActionBlock previousBlock = null;
            for (BatchActionBlock currentBlock : localCopy) {
                int blockIndex = localCopy.indexOf((Object)currentBlock);
                if (!relativeStart || blockIndex != 0) {
                    if (previousBlock != null) {
                        HighResolutionCalendar currentTime = this.getTime(currentBlock);
                        HighResolutionCalendar previousTime = this.getTime(previousBlock);
                        if (previousTime.compareTo((Calendar)currentTime) > 0) {
                            localCopy.move(blockIndex, (Object)previousBlock);
                            BatchActionBlockController controller = ControllerFactory.create(previousBlock);
                            this.append(controller.createMoveCommand(blockIndex));
                            continue block0;
                        }
                    }
                    previousBlock = currentBlock;
                }
                if (blockIndex != localCopy.size() - 1) continue;
                this.sorted = true;
            }
        }
    }

    private HighResolutionCalendar getTime(BatchActionBlock block) {
        BatchAction firstAction = (BatchAction)block.getBatchActions().get(0);
        return firstAction.getStartTime();
    }
}

