/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.Measurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.reader.EByteBlowerObjectReader;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.FlowReader;
import com.excentis.products.byteblower.model.reader.FrameBlastingBenchmarkReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithStringReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import com.excentis.products.byteblower.utils.cloud.CloudStatusPoller;
import com.excentis.products.byteblower.utils.cloud.ExcentisCloudStatus;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ScenarioController
extends EByteBlowerObjectController<Scenario>
implements ScenarioReader {
    private static final String newScenarioPrefix = "SCENARIO_";
    private final Comparator<FlowMeasurement> comparator = new Comparator<FlowMeasurement>(){

        @Override
        public int compare(FlowMeasurement a, FlowMeasurement b) {
            FlowMeasurementReaderImpl readerA = new FlowMeasurementReaderImpl(a);
            FlowMeasurementReaderImpl readerB = new FlowMeasurementReaderImpl(b);
            return readerA.getStartTime().compareTo((Calendar)readerB.getStartTime());
        }
    };
    private ScenarioReader reader;
    private static boolean allowCloudFunctionality = false;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$utils$cloud$ExcentisCloudStatus = ScenarioController.$SWITCH_TABLE$com$excentis$products$byteblower$utils$cloud$ExcentisCloudStatus();
    }

    @Override
    public void createStatuses() {
        EList<FlowMeasurement> measurements = this.getFlowMeasurements();
        if (allowCloudFunctionality) {
            ExcentisCloudStatus currentStatus = CloudStatusPoller.getInstance().now().status();
            switch (currentStatus) {
                case ALL_OK: {
                    break;
                }
                case BAD_EC_CREDENTIALS: {
                    this.addWarningStatus("Excentis Cloud - Invalid Credentials");
                    break;
                }
                case EC_UNREACHABLE: {
                    this.addWarningStatus("Excentis Cloud - Unreachable");
                    break;
                }
                case MISSING_EC_CLOUD_CONFIG: {
                    this.addWarningStatus("Excentis Cloud - Invalid Configuration");
                    break;
                }
                case OPT_OUT_EC_CLOUD: {
                    break;
                }
            }
        }
        if (measurements.isEmpty()) {
            this.addErrorStatus("Missing Flows");
        } else if (this.preventResultsOverTime()) {
            this.addWarningStatus("Large scenario with more than 100 flows) Graphs with results over time will be disabled. Double-click here for help.", "https://support.excentis.com/index.php?/Knowledgebase/Article/View/running-big-scenarios");
        }
        boolean missingFlow = false;
        boolean missingFlows = false;
        for (FlowMeasurement measurement : measurements) {
            FlowTemplate flowTemplate;
            FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)measurement);
            if (reader.getFlow() == null) {
                if (missingFlow) {
                    missingFlows = true;
                    break;
                }
                missingFlow = true;
                continue;
            }
            FlowReader flowReader = reader.getFlowReader();
            this.addDependingStatus("Flow", (EByteBlowerObjectReader<?>)flowReader);
            if (reader.isOverlapping()) {
                this.addErrorStatus("Flow (" + flowReader.getName() + ") overlaps with other Flows");
            }
            if (!((flowTemplate = flowReader.getFlowTemplate()) instanceof FrameBlastingBenchmark)) continue;
            this.checkRFC2544(reader, (FrameBlastingBenchmark)flowTemplate);
        }
        if (missingFlow) {
            this.addErrorStatus("Missing " + (missingFlows ? "Flows" : "Flow"));
        }
    }

    private void checkRFC2544(FlowMeasurementReader reader, FrameBlastingBenchmark flowTemplate) {
        HighResolutionDuration totalDuration = reader.getDuration();
        FrameBlastingBenchmarkReader fbBench = ReaderFactory.create((FrameBlastingBenchmark)flowTemplate);
        HighResolutionDuration iteration = fbBench.getIterationDuration((HighResolutionCalendar)totalDuration);
        if (iteration.compareTo((Calendar)FrameBlastingBenchmarkReader.MINIMUM_ITERATION_DURATION) < 0) {
            HighResolutionDuration minTotal = fbBench.getEstimatedDuration((HighResolutionCalendar)FrameBlastingBenchmarkReader.MINIMUM_ITERATION_DURATION);
            String minimumDurationTxt = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)minTotal);
            String msgFmt = "The duration of the RFC-2544 test ( '%s' ) is too short. Increase it to at least %s";
            this.addErrorStatus(String.format(msgFmt, reader.getFlow().getName(), minimumDurationTxt));
        }
    }

    ScenarioController(Scenario myScenario) {
        super(myScenario);
    }

    private static final Scenario create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createScenario();
    }

    protected static final Scenario create(ByteBlowerProject byteblowerProject, String referenceName) {
        String newName;
        Scenario newScenario = ScenarioController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newScenario, (String)(newName = referenceName))) {
            newName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newScenario, (String)newName, (String)newScenarioPrefix);
        }
        newScenario.setName(newName);
        return newScenario;
    }

    public boolean isContained() {
        Scenario myScenario = (Scenario)this.getObject();
        return myScenario != null && myScenario.eContainer() != null;
    }

    public final Object[] copyFlowMeasurement(Collection<FlowMeasurement> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (FlowMeasurement object : objects) {
            FlowMeasurement copy = (FlowMeasurement)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        FlowMeasurement[] array = (FlowMeasurement[])copiedObjects.toArray((Object[])new FlowMeasurement[objects.size()]);
        return new Object[]{array};
    }

    public final ScenarioFlowEventController.CommandWithFlowMeasurementListReference pasteFlowMeasurement(FlowMeasurement[] copiedFrameBlastingFrames, int pasteIndex) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        CompoundCommand referenceSetCompound = new CompoundCommand();
        BasicEList pastedFrameblastingFramesControllers = new BasicEList();
        BasicEList pastedFrameBlastingFrames = new BasicEList();
        if (copiedFrameBlastingFrames != null) {
            FlowMeasurement[] flowMeasurementArray = copiedFrameBlastingFrames;
            int n = copiedFrameBlastingFrames.length;
            int n2 = 0;
            while (n2 < n) {
                FlowMeasurement copiedFrameBlastingFrame = flowMeasurementArray[n2];
                FlowMeasurement frameBlastingFrame = (FlowMeasurement)this.duplicate(referenceSetCompound, (EByteBlowerObject)copiedFrameBlastingFrame);
                if (frameBlastingFrame != null) {
                    FlowMeasurementController FrameBlastingFrameController2 = new FlowMeasurementController(frameBlastingFrame);
                    pastedFrameBlastingFrames.add((Object)frameBlastingFrame);
                    pastedFrameblastingFramesControllers.add((Object)FrameBlastingFrameController2);
                }
                ++n2;
            }
            compound.appendCommand(this.createAddCommand((Collection<FlowMeasurement>)pastedFrameBlastingFrames, pasteIndex));
            compound.appendCommand((Command)referenceSetCompound);
        }
        return new ScenarioFlowEventController.CommandWithFlowMeasurementListReference(compound.unwrap(), (List<FlowMeasurementController>)pastedFrameblastingFramesControllers);
    }

    private final Command createAddCommand(FlowMeasurement measurement) {
        Scenario myScenario = (Scenario)this.getObject();
        if (myScenario != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO__MEASUREMENTS, measurement);
        }
        return null;
    }

    private final Command createAddCommand(Collection<FlowMeasurement> measurements) {
        Scenario myScenario = (Scenario)this.getObject();
        if (myScenario != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO__MEASUREMENTS, measurements);
        }
        return null;
    }

    private final Command createAddCommand(FlowMeasurement measurement, int index) {
        Scenario myScenario = (Scenario)this.getObject();
        if (myScenario != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO__MEASUREMENTS, measurement, index);
        }
        return null;
    }

    private final Command createAddCommand(Collection<FlowMeasurement> measurements, int index) {
        Scenario myScenario = (Scenario)this.getObject();
        if (myScenario != null) {
            return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.SCENARIO__MEASUREMENTS, measurements, index);
        }
        return null;
    }

    public final ScenarioFlowEventController.CommandWithFlowMeasurementListReference addFlowMeasurement() {
        return this.addFlowMeasurements(1);
    }

    private final ScenarioFlowEventController.CommandWithFlowMeasurementListReference addFlowMeasurements(int amount) {
        return this.addFlowMeasurements(amount, -1);
    }

    public final ScenarioFlowEventController.CommandWithFlowMeasurementListReference addFlowMeasurements(int amount, int index) {
        if (amount > 0) {
            Scenario myScenario = (Scenario)this.getObject();
            CompoundCommandController compoundCommandController = CompoundCommandController.createInstance();
            if (myScenario != null) {
                UniqueEList controllers = new UniqueEList();
                if (amount == 1) {
                    FlowMeasurement newObject = FlowMeasurementController.create();
                    controllers.add((Object)ControllerFactory.create(newObject));
                    compoundCommandController.appendCommand(index == -1 ? this.createAddCommand(newObject) : this.createAddCommand(newObject, index));
                } else {
                    UniqueEList newObjects = new UniqueEList();
                    int i = 0;
                    while (i < amount) {
                        FlowMeasurement newObject = FlowMeasurementController.create();
                        newObjects.add((Object)newObject);
                        controllers.add((Object)ControllerFactory.create(newObject));
                        ++i;
                    }
                    compoundCommandController.appendCommand(index == -1 ? this.createAddCommand((Collection<FlowMeasurement>)newObjects) : this.createAddCommand((Collection<FlowMeasurement>)newObjects, index));
                }
                return new ScenarioFlowEventController.CommandWithFlowMeasurementListReference(compoundCommandController.unwrap(), (List<FlowMeasurementController>)controllers);
            }
        }
        return null;
    }

    public final CommandWithStringReference setIncrementedName(Scenario selectedScenario, List<String> takenNames) {
        String newName = OldNamingTools.getIncrementedName((String)selectedScenario.getName(), takenNames);
        Command newCommand = this.createSetNameCommand(newName);
        return new CommandWithStringReference(newCommand, newName);
    }

    public final EList<FlowMeasurement> getFlowMeasurementsSorted() {
        UniqueEList flowMeasurements = this.getFlowMeasurements();
        int size = flowMeasurements.size();
        FlowMeasurement[] sorted = (FlowMeasurement[])flowMeasurements.toArray((Object[])new FlowMeasurement[size]);
        Arrays.sort(sorted, this.comparator);
        flowMeasurements = new UniqueEList();
        FlowMeasurement[] flowMeasurementArray = sorted;
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            FlowMeasurement flowMeasurement = flowMeasurementArray[n2];
            flowMeasurements.add((Object)flowMeasurement);
            ++n2;
        }
        return flowMeasurements;
    }

    private ScenarioReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((Scenario)((Scenario)this.getObject()));
        }
        return this.reader;
    }

    public EList<FlowMeasurement> getFlowMeasurements() {
        return this.getReader().getFlowMeasurements();
    }

    public EList<ByteBlowerGuiPort> getInvolvedPorts() {
        return this.getReader().getInvolvedPorts();
    }

    public EList<ScenarioReader.ServerDescription> getInvolvedServers() {
        return this.getReader().getInvolvedServers();
    }

    public HighResolutionDuration getDuration() {
        return this.getReader().getDuration();
    }

    public EList<Measurement> getMeasurements() {
        return this.getReader().getMeasurements();
    }

    public List<FlowMeasurement> getSortedFlowMeasurements() {
        return this.getReader().getSortedFlowMeasurements();
    }

    public boolean allowResultsOverTime() {
        return this.getReader().allowResultsOverTime();
    }

    public boolean preventResultsOverTime() {
        return this.getReader().preventResultsOverTime();
    }

    public boolean blockResultsOverTime() {
        return this.getReader().blockResultsOverTime();
    }

    public static void allowCloudFunctionality() {
        allowCloudFunctionality = true;
    }
}

