/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.FlowTemplateController;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class TcpFlowController
extends FlowTemplateController<TcpFlow>
implements TcpFlowReader {
    private static final String newTcpFlowPrefix = "TCP_";
    private TcpFlowReader reader;

    TcpFlowController(TcpFlow myTcpFlow) {
        super(myTcpFlow);
    }

    private static final TcpFlow create() {
        return EByteBlowerObjectController.getByteblowerguimodelFactory().createTcpFlow();
    }

    protected static final TcpFlow create(ByteBlowerProject byteblowerProject, String referenceTcpFlowName) {
        String newTcpFlowName;
        TcpFlow newTcpFlow = TcpFlowController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newTcpFlow, (String)(newTcpFlowName = referenceTcpFlowName))) {
            newTcpFlowName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newTcpFlow, (String)newTcpFlowName, (String)newTcpFlowPrefix);
        }
        newTcpFlow.setName(newTcpFlowName);
        newTcpFlow.setPayloadSize("Unlimited");
        newTcpFlow.setWindowSize("65535");
        newTcpFlow.setSlowStart(Integer.MAX_VALUE);
        return newTcpFlow;
    }

    public Command setHTTPMethod(HTTPMethod httpMethod) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__HTTP_METHOD, httpMethod);
        return setCommand;
    }

    public Command setPayloadSize(String payloadSize) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_SIZE, payloadSize);
        return setCommand;
    }

    public Command setRcvWindowScale(byte rcvWindowScale) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RCV_WINDOW_SCALE, rcvWindowScale);
        return setCommand;
    }

    public Command setTCPCongestionAvoidanceAlgorithm(TCPCongestionAvoidanceAlgorithm tcpCongestionAvoidanceAlgorithm) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__TCP_CONGESTION_AVOIDANCE_ALGORITHM, tcpCongestionAvoidanceAlgorithm);
        return setCommand;
    }

    public Command setWindowSize(String windowSize) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SIZE, windowSize);
        return setCommand;
    }

    public Command setWindowScaling(boolean windowScaling) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SCALING, windowScaling);
        return setCommand;
    }

    public Command setRateLimitUnit(DataRateUnit unit) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT_UNIT, unit);
        return setCommand;
    }

    public Command setRateLimit(float throughput) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT, Float.valueOf(throughput));
        return setCommand;
    }

    public Command setPayloadUnit(PayloadUnit unit) {
        Command setCommand = this.createSetCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_UNIT, unit);
        return setCommand;
    }

    public TCPCongestionAvoidanceAlgorithm getTCPCongestionAvoidanceAlgorithm() {
        return this.getReader().getTCPCongestionAvoidanceAlgorithm();
    }

    private TcpFlowReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((TcpFlow)((TcpFlow)this.getObject()));
        }
        return this.reader;
    }

    public boolean hasAutomaticClientPort() {
        return this.getReader().hasAutomaticClientPort();
    }

    public boolean hasAutomaticServerPort() {
        return this.getReader().hasAutomaticServerPort();
    }

    public String getClientPort() {
        return this.getReader().getClientPort();
    }

    public String getServerPort() {
        return this.getReader().getServerPort();
    }

    public int getRcvWindowScale() {
        return this.getReader().getRcvWindowScale();
    }

    public boolean isTimeBased() {
        return this.getReader().isTimeBased();
    }

    public float getPayloadSize() {
        return this.getReader().getPayloadSize();
    }

    public Integer getClientPortNumber() {
        return this.getReader().getClientPortNumber();
    }

    public Integer getServerPortNumber() {
        return this.getReader().getServerPortNumber();
    }

    public boolean usesReceiveWindowScaling() {
        return this.getReader().usesReceiveWindowScaling();
    }

    public Integer getInitialReceiveWindowSizeNumber() {
        return this.getReader().getInitialReceiveWindowSizeNumber();
    }

    public Integer getReceiveWindowScalingValueNumber() {
        return this.getReader().getReceiveWindowScalingValueNumber();
    }

    public String getPayloadSizeString() {
        return this.getReader().getPayloadSizeString();
    }

    public String getWindowSizeString() {
        return this.getReader().getWindowSizeString();
    }

    public String isWindowScalingString() {
        return this.getReader().isWindowScalingString();
    }

    public String getRcvWindowScaleString() {
        return this.getReader().getRcvWindowScaleString();
    }

    public String getHTTPMethodString() {
        return this.getReader().getHTTPMethodString();
    }

    public String getTCPCongestionAvoidanceAlgorithmString() {
        return this.getReader().getTCPCongestionAvoidanceAlgorithmString();
    }

    public String getClientPortString() {
        return this.getReader().getClientPortString();
    }

    public String getServerPortString() {
        return this.getReader().getServerPortString();
    }

    public boolean isRateLimited() {
        return this.getReader().isRateLimited();
    }

    public String getRateLimitString() {
        return this.getReader().getRateLimitString();
    }

    public PayloadUnit getPayloadUnit() {
        return this.getReader().getPayloadUnit();
    }

    public float getPayloadSizeInBytes() {
        return this.getReader().getPayloadSizeInBytes();
    }

    public boolean isPayloadBased() {
        return this.getReader().isPayloadBased();
    }

    public long getRateLimitInBitsps() {
        return this.getReader().getRateLimitInBitsps();
    }

    public long getRateLimitInBytesps() {
        return this.getReader().getRateLimitInBytesps();
    }

    public DataRateUnit getRateLimitUnit() {
        return this.getReader().getRateLimitUnit();
    }

    public float getRateLimit() {
        return this.getReader().getRateLimit();
    }

    public String getSlowStartString() {
        return this.getReader().getSlowStartString();
    }

    public int getSlowStartThreshold() {
        return this.getReader().getSlowStartThreshold();
    }

    public List<SupportedLayer3Configuration> getSupportedLayer3Types() {
        return this.getReader().getSupportedLayer3Types();
    }

    @Override
    public void createStatuses() {
        if (this.hasInvalidPayloadSize()) {
            this.addErrorStatus("The payload must be at least 500 bytes");
        }
    }

    public boolean hasInvalidPayloadSize() {
        return this.getReader().hasInvalidPayloadSize();
    }

    public String isL4SString() {
        return this.getReader().isL4SString();
    }

    public boolean isL4S() {
        return this.getReader().isL4S();
    }
}

