/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.EByteBlowerObjectController;
import com.excentis.products.byteblower.model.control.VlanController;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.util.EByteBlowercoreUtil;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import com.excentis.products.byteblower.object.control.CommandWithStringReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class VlanStackController
extends EByteBlowerObjectController<VlanStack>
implements VlanStackReader {
    private static final String newVlanStackPrefix = "VLAN_STACK_";
    private VlanStackReader reader;

    VlanStackController(VlanStack vlanStack) {
        super(vlanStack);
    }

    private static final VlanStack create() {
        VlanStack newVlanStack = EByteBlowerObjectController.getByteblowerguimodelFactory().createVlanStack();
        return newVlanStack;
    }

    protected static final VlanStack create(ByteBlowerProject byteblowerProject, String referenceVlanStackName) {
        String newVlanStackName;
        VlanStack newVlanStack = VlanStackController.create();
        if (!OldNamingTools.nameIsUnique((ByteBlowerProject)byteblowerProject, (EObject)newVlanStack, (String)(newVlanStackName = referenceVlanStackName))) {
            newVlanStackName = OldNamingTools.getIncrementedName((ByteBlowerProject)byteblowerProject, (EObject)newVlanStack, (String)newVlanStackName, (String)newVlanStackPrefix);
        }
        newVlanStack.setName(newVlanStackName);
        return newVlanStack;
    }

    public final Object[] copyVlans(Collection<Vlan> objects) {
        UniqueEList copiedObjects = new UniqueEList();
        for (Vlan object : objects) {
            Vlan copy = (Vlan)EByteBlowercoreUtil.copy((EObject)object);
            copiedObjects.add((Object)copy);
        }
        Vlan[] array = (Vlan[])copiedObjects.toArray((Object[])new Vlan[objects.size()]);
        return new Object[]{array};
    }

    public EList<Vlan> getVlans() {
        return this.getReader().getVlans();
    }

    public EList<VlanController> getVlanControllers() {
        UniqueEList vlanControllers = new UniqueEList();
        VlanStack myVlanStack = (VlanStack)this.getObject();
        if (myVlanStack != null) {
            for (Vlan vlan : this.getVlans()) {
                vlanControllers.add((Object)ControllerFactory.create(vlan));
            }
        }
        return vlanControllers;
    }

    public final CommandWithStringReference setIncrementedName(VlanStack selectedVlanStack, List<String> takenNames) {
        String newName = OldNamingTools.getIncrementedName((String)selectedVlanStack.getName(), takenNames);
        Command newCommand = this.createSetNameCommand(newName);
        return new CommandWithStringReference(newCommand, newName);
    }

    private VlanStackReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((VlanStack)((VlanStack)this.getObject()));
        }
        return this.reader;
    }

    public List<VlanReader> getVlanReaders() {
        return this.getReader().getVlanReaders();
    }

    public Command createAddVlanCommand(Vlan newVlan) {
        return this.createAddVlanCommand(newVlan, -1);
    }

    private Command createAddVlanCommand(Vlan object, int index) {
        return this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN_STACK__VLANS, object, index);
    }

    public Command createAddVlanCommand(Collection<Vlan> newVlans) {
        return this.createAddVlanCommand(newVlans, -1);
    }

    Command createAddVlanCommand(Collection<Vlan> newVlans, int index) {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.createAddCommand((EStructuralFeature)ByteblowerguimodelPackage.Literals.VLAN_STACK__VLANS, newVlans, index));
        compound.appendCommand(this.createSetStatusUnknownCommand());
        return compound.unwrap();
    }

    public boolean isEmpty() {
        return this.getReader().isEmpty();
    }

    @Override
    public void createStatuses() {
        if (this.isEmpty()) {
            this.addErrorStatus("Vlan Stack is empty");
        }
    }
}

