/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.AbstractServerReader;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.LicenseType;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Version;

public class AbstractServerController<ServerType extends AbstractServer>
extends EByteBlowerServerObjectController<ServerType>
implements AbstractServerReader<ServerType> {
    private AbstractServerReader<?> reader = null;

    public AbstractServerController(ServerType server) {
        super(server);
    }

    private AbstractServerReader<?> getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((AbstractServer)((AbstractServer)this.getObject()));
        }
        return this.reader;
    }

    public boolean hasPhysicalServer(AbstractServer AbstractServer2) {
        AbstractServer myPhysicalServer = (AbstractServer)this.getObject();
        if (myPhysicalServer != null) {
            return myPhysicalServer == AbstractServer2;
        }
        return false;
    }

    private static AbstractServer createEmptyPhysicalServer() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalServer();
    }

    public static AbstractServer create() {
        AbstractServer AbstractServer2 = AbstractServerController.createEmptyPhysicalServer();
        return AbstractServer2;
    }

    protected final Command setHostName(String newHostName) {
        return this.createSetHostNameCommand(newHostName);
    }

    public final Command setLocalName(String newLocalName) {
        return this.createSetLocalNameCommand(newLocalName);
    }

    public final Command setServerType(String newBBType) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__SERVER_TYPE, newBBType);
    }

    public final Command setServerLinkStatus(ServerLinkStatus newServerStatus) {
        return this.createSetStatusCommand(newServerStatus);
    }

    private EAttribute getStatusEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__SERVER_LINK_STATUS;
    }

    private Command createSetStatusCommand(ServerLinkStatus newStatus) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getStatusEAttribute(), newStatus);
    }

    public final Command setVolatile(Boolean isVolatile) {
        return this.createSetVolatileCommand(isVolatile);
    }

    public final Command setVersion(String newVersion) {
        return this.createSetVersionCommand(newVersion);
    }

    protected final Command setSysLocation(String newSysLocation) {
        return this.createSetSysLocationCommand(newSysLocation);
    }

    public void setCurrentUsers(List<String> newCurrentUsers) {
        AbstractServer myPhysicalServer = (AbstractServer)this.getObject();
        if (myPhysicalServer != null) {
            myPhysicalServer.setCurrentUsers((EList)new BasicEList(newCurrentUsers));
        }
    }

    protected final Command setAvahiAvailable(Boolean isAvahiAvailable) {
        return this.createSetAvahiAvailableCommand(isAvahiAvailable);
    }

    private EAttribute getAddressEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__ADDRESS;
    }

    public Command createSetAddressCommand(String newAddress) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getAddressEAttribute(), newAddress);
    }

    private EAttribute getVersionEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__VERSION;
    }

    private Command createSetVersionCommand(String newVersion) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getVersionEAttribute(), newVersion);
    }

    private EAttribute getHostNameEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__HOST_NAME;
    }

    private Command createSetHostNameCommand(String newHostName) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getHostNameEAttribute(), newHostName);
    }

    private EAttribute getLocalNameEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__LOCAL_NAME;
    }

    public Command createSetLocalNameCommand(String newLocalName) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getLocalNameEAttribute(), newLocalName);
    }

    private EAttribute getAvahiIDEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__AVAHI_ID;
    }

    private EAttribute getSysLocationEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__SYS_LOCATION;
    }

    private Command createSetSysLocationCommand(String newSysLocation) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getSysLocationEAttribute(), newSysLocation);
    }

    private Command createSetAvahiIDCommand(String newAvahiID) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getAvahiIDEAttribute(), newAvahiID);
    }

    private EAttribute getAvahiAvailableEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__AVAHI_AVAILABLE;
    }

    private Command createSetAvahiAvailableCommand(Boolean isAvahiAvailable) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getAvahiAvailableEAttribute(), isAvahiAvailable);
    }

    private EAttribute getVolatileEAttribute() {
        return ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__VOLATILE;
    }

    private Command createSetVolatileCommand(Boolean isVolatile) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getVolatileEAttribute(), isVolatile);
    }

    public boolean isAvahiAvailable() {
        return this.getReader().isAvahiAvailable();
    }

    public ServerLinkStatus getServerLinkStatus() {
        return this.getReader().getServerLinkStatus();
    }

    public String getServerAddress() {
        return this.getReader().getServerAddress();
    }

    public boolean hasUpdateAvailable() {
        return this.getReader().hasUpdateAvailable();
    }

    public Version getCurrentVersion() {
        return this.getReader().getCurrentVersion();
    }

    public Version getLatestVersion() {
        return null;
    }

    public Command setLinkStatusUnknown() {
        return this.setServerLinkStatus(ServerLinkStatus.UNKNOWN);
    }

    public Command undock() {
        return null;
    }

    public Command refreshPorts() {
        return null;
    }

    public Collection<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public Command selfDestroy() {
        return null;
    }

    public boolean isAbstract() {
        return !(this.getObject() instanceof PhysicalServer) && !(this.getObject() instanceof MeetingPoint);
    }

    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return this.getReader().getPhysicalDockable(portConfigReader);
    }

    public String getLocalName() {
        return this.getReader().getLocalName();
    }

    public Collection<DockedByteBlowerPortController> getAllDockedPortControllers() {
        Collection<DockedByteBlowerPortReader> readers = this.getAllDockedPortReaders();
        ArrayList<DockedByteBlowerPortController> controllers = new ArrayList<DockedByteBlowerPortController>();
        for (DockedByteBlowerPortReader reader : readers) {
            DockedByteBlowerPortController controller = ControllerFactory.create((DockedByteBlowerPort)reader.getObject());
            controllers.add(controller);
        }
        return controllers;
    }

    public String getServerInfoString() {
        return this.getReader().getServerInfoString();
    }

    public String getServerVersionString() {
        return this.getReader().getServerVersionString();
    }

    public Command setLicense(LicenseType type) {
        return this.checkAndCreateSetCommand((EStructuralFeature)ByteBlowerServerModelPackage.Literals.ABSTRACT_SERVER__LICENSE_TYPE, type);
    }

    public LicenseType getLicenseType() {
        return this.getReader().getLicenseType();
    }

    public boolean needsRefresh() {
        return this.getReader().needsRefresh();
    }

    public boolean isLicenseNotBought() {
        return this.getReader().isLicenseNotBought();
    }

    public String getServerType() {
        return this.getReader().getServerType();
    }
}

