/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.PhysicalDockableController;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.MobileDeviceReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.InterfaceLinkStatus;
import com.excentis.products.byteblower.server.model.MeetingPoint;
import com.excentis.products.byteblower.server.model.MobileInterface;
import com.excentis.products.byteblower.server.model.MobileType;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalMobileDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class MobileDeviceController
extends PhysicalDockableController<PhysicalMobileDevice>
implements MobileDeviceReader {
    private MobileDeviceReader reader = null;

    private MobileDeviceReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PhysicalMobileDevice)((PhysicalMobileDevice)this.getObject()));
        }
        return this.reader;
    }

    public MobileDeviceController(PhysicalMobileDevice myMobileDevice) {
        super(myMobileDevice);
    }

    private static PhysicalMobileDevice createEmptyMobileDevice() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalMobileDevice();
    }

    static PhysicalMobileDevice create() {
        PhysicalMobileDevice MobileDevice = MobileDeviceController.createEmptyMobileDevice();
        return MobileDevice;
    }

    public final void updateNow() {
        PhysicalMobileDevice myMobileDevice = (PhysicalMobileDevice)this.getObject();
        if (myMobileDevice != null) {
            myMobileDevice.setNeedsUpdate(1);
        }
    }

    public MobileType getMobileType() {
        return this.getReader().getMobileType();
    }

    public PhysicalDockable getPhysicalDockable() {
        return (PhysicalDockable)this.getObject();
    }

    public EList<ByteBlowerGuiPortConfiguration> getDockedPortConfigurations() {
        return this.getReader().getDockedPortConfigurations();
    }

    public String getDeviceId() {
        return this.getReader().getDeviceId();
    }

    public AbstractServer getServer() {
        return this.getReader().getServer();
    }

    public String getMacAddressString() {
        return this.getReader().getMacAddressString();
    }

    public InterfaceLinkStatus getInterfaceLinkStatus() {
        return this.getReader().getInterfaceLinkStatus();
    }

    public EList<DockedByteBlowerPort> getDockedPorts() {
        return this.getReader().getDockedPorts();
    }

    public Command undock() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
            compound.appendCommand(controller.undock());
            compound.appendCommand(this.undock(portConfig));
        }
        return compound.getCompoundCommand();
    }

    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        return this.getReader().getAllDockedPorts();
    }

    @Override
    public List<DockedByteBlowerPortController> getAllDockedPortControllers() {
        ArrayList<DockedByteBlowerPortController> controllers = new ArrayList<DockedByteBlowerPortController>();
        EList<DockedByteBlowerPort> dockedPorts = this.getAllDockedPorts();
        for (DockedByteBlowerPort dockedPort : dockedPorts) {
            controllers.add(ControllerFactory.create(dockedPort));
        }
        return controllers;
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public EList<ByteBlowerGuiPortConfiguration> getAllDockedPortConfigurations() {
        return this.getReader().getAllDockedPortConfigurations();
    }

    public Command refreshPorts() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
            compound.appendCommand(controller.createSetStatusUnknownCommand());
        }
        return compound.getCompoundCommand();
    }

    public MeetingPoint getMeetingPoint() {
        return ((PhysicalMobileDevice)this.getObject()).getMeetingPoint();
    }

    public final Command setId(String id) {
        return this.createSetIdCommand(id);
    }

    private EAttribute getIdEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__ID;
    }

    private Command createSetIdCommand(String newId) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getIdEAttribute(), newId);
    }

    public Command setType(MobileType type) {
        return this.checkAndCreateSetCommand(this.getTypeEAttribute(), type);
    }

    private EStructuralFeature getTypeEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__MOBILE_TYPE;
    }

    public Command setOsVersion(String osVersion) {
        return this.checkAndCreateSetCommand(this.getOsVersionEAttribute(), osVersion);
    }

    private EStructuralFeature getOsVersionEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__OS_VERSION;
    }

    public String getOsVersion() {
        return this.getReader().getOsVersion();
    }

    public Command setMobileAppVersion(String appVersion) {
        return this.checkAndCreateSetCommand(this.getAppVersionEAttribute(), appVersion);
    }

    private EStructuralFeature getAppVersionEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__APP_VERSION;
    }

    public String getAppVersion() {
        return this.getReader().getAppVersion();
    }

    public Command setBatteryLevel(long batteryLevel) {
        return this.checkAndCreateSetCommand(this.getBatteryLevelEAttribute(), batteryLevel);
    }

    private EStructuralFeature getBatteryLevelEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__BATTERY_LEVEL;
    }

    public String getMobileTypeString() {
        return this.getReader().getMobileTypeString();
    }

    public long getBatteryLevel() {
        return this.getReader().getBatteryLevel();
    }

    public String getBatteryLevelString(boolean forToolTip) {
        return this.getReader().getBatteryLevelString(forToolTip);
    }

    public String getDeviceType() {
        return this.getReader().getDeviceType();
    }

    public Command setDeviceType(String deviceType) {
        return this.checkAndCreateSetCommand(this.getDeviceTypeEAttribute(), deviceType);
    }

    private EStructuralFeature getDeviceTypeEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__DEVICE_TYPE;
    }

    public Command setLockOwner(String lockOwner) {
        return this.checkAndCreateSetCommand(this.getLockOwnerEAttribute(), lockOwner);
    }

    public String getLockOwner() {
        return this.getReader().getLockOwner();
    }

    private EStructuralFeature getLockOwnerEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__LOCK_OWNER;
    }

    private EStructuralFeature getLockEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__IS_LOCKED;
    }

    public Command setIsLocked(boolean isLocked) {
        return this.checkAndCreateSetCommand(this.getLockEAttribute(), isLocked);
    }

    public boolean isLocked() {
        return this.getReader().isLocked();
    }

    public String getIpAddress() {
        return this.getReader().getIpAddress();
    }

    public String getIpv6Address() {
        return this.getReader().getIpv6Address();
    }

    public Command setLockIsOwner(boolean lockIsOwner) {
        return this.checkAndCreateSetCommand(this.getLockIsOwnerEAttribute(), lockIsOwner);
    }

    public boolean getLockIsOwner() {
        return this.getReader().getLockIsOwner();
    }

    private EStructuralFeature getLockIsOwnerEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__LOCK_IS_OWNER;
    }

    public boolean isTestRunning() {
        return this.getReader().isTestRunning();
    }

    private EStructuralFeature getDeviceStatus() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__MOBILE_STATUS;
    }

    public Command setLinkStatus(InterfaceLinkStatus link) {
        return this.checkAndCreateSetCommand(this.getDeviceStatus(), link);
    }

    public Command removeInterfaces() {
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        EList currentNetIfs = obj.getInterfaces();
        if (!currentNetIfs.isEmpty()) {
            return RemoveCommand.create((EditingDomain)editingDomain, (Collection)currentNetIfs);
        }
        return this.createEmptyCommand();
    }

    public Command addInterfaces(MobileInterface netInterface) {
        PhysicalMobileDevice obj = (PhysicalMobileDevice)this.getObject();
        return AddCommand.create((EditingDomain)editingDomain, (Object)obj, (Object)ByteBlowerServerModelPackage.Literals.PHYSICAL_MOBILE_DEVICE__INTERFACES, (Object)netInterface);
    }

    public boolean hasIpv6() {
        return this.getReader().hasIpv6();
    }

    public int getPrefixLength() {
        return this.getReader().getPrefixLength();
    }
}

