/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortConfigurationController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.PhysicalDockableController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalPortReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.AbstractServer;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.DockedByteBlowerPort;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalPort;
import com.excentis.products.byteblower.server.model.PortLinkStatus;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class PhysicalPortController
extends PhysicalDockableController<PhysicalPort>
implements PhysicalPortReader {
    private PhysicalPortReader reader = null;

    private PhysicalPortReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PhysicalPort)((PhysicalPort)this.getObject()));
        }
        return this.reader;
    }

    public PhysicalPortController(PhysicalPort myPhysicalPort) {
        super(myPhysicalPort);
    }

    private static final PhysicalPort createEmptyPhysicalPort() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalPort();
    }

    public static final PhysicalPort create(int id) {
        PhysicalPort physicalPort = PhysicalPortController.createEmptyPhysicalPort();
        physicalPort.setId(Integer.valueOf(id));
        return physicalPort;
    }

    public PhysicalInterface getPhysicalInterface() {
        PhysicalPort myPhysicalPort = (PhysicalPort)this.getObject();
        if (myPhysicalPort != null) {
            return myPhysicalPort.getPhysicalInterface();
        }
        return null;
    }

    public EList<ByteBlowerGuiPortConfiguration> getDockedPortConfigurations() {
        return this.getReader().getDockedPortConfigurations();
    }

    public Integer getPortId() {
        return this.getReader().getPortId();
    }

    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return this.getReader().getPhysicalDockable(portConfigReader);
    }

    public PhysicalInterfaceReader getPhysicalInterfaceReader() {
        return this.getReader().getPhysicalInterfaceReader();
    }

    private EAttribute getLinkStatusEAttribute() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_PORT__PORT_LINK_STATUS;
    }

    private Command createSetLinkStatusCommand(PortLinkStatus linkStatus) {
        return this.checkAndCreateSetCommand((EStructuralFeature)this.getLinkStatusEAttribute(), linkStatus);
    }

    public Command setPortLinkStatus(PortLinkStatus linkStatus) {
        return this.createSetLinkStatusCommand(linkStatus);
    }

    public EList<DockedByteBlowerPort> getDockedPorts() {
        return this.getReader().getDockedPorts();
    }

    public Command undock() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            compound.appendCommand(this.undock(portConfig));
        }
        return compound.getCompoundCommand();
    }

    public PortLinkStatus getPortLinkStatus() {
        return this.getReader().getPortLinkStatus();
    }

    public EList<DockedByteBlowerPort> getAllDockedPorts() {
        return this.getReader().getAllDockedPorts();
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public EList<ByteBlowerGuiPortConfiguration> getAllDockedPortConfigurations() {
        return this.getReader().getAllDockedPortConfigurations();
    }

    public Command createAddDockedPortsCommand(EList<DockedByteBlowerPort> dockedPorts) {
        return this.createAddCommand((EStructuralFeature)this.getDockedPortEReference(), (Collection<?>)dockedPorts);
    }

    private EReference getDockedPortEReference() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_DOCKABLE__DOCKED_PORTS;
    }

    public AbstractServer getServer() {
        return this.getReader().getServer();
    }

    Command refreshPorts() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPortConfiguration portConfig : this.getDockedPortConfigurations()) {
            ByteBlowerGuiPortConfigurationController controller = ControllerFactory.create(portConfig);
            compound.appendCommand(controller.createSetStatusUnknownCommand());
        }
        return compound.getCompoundCommand();
    }
}

