/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.control.server;

import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.server.AbstractServerController;
import com.excentis.products.byteblower.model.control.server.DockedByteBlowerPortController;
import com.excentis.products.byteblower.model.control.server.EByteBlowerServerObjectController;
import com.excentis.products.byteblower.model.control.server.PhysicalConfigurationController;
import com.excentis.products.byteblower.model.control.server.PhysicalInterfaceController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.server.DockedByteBlowerPortReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalInterfaceReader;
import com.excentis.products.byteblower.model.reader.server.PhysicalServerReader;
import com.excentis.products.byteblower.model.transfer.PhysicalConfigurationTransfer;
import com.excentis.products.byteblower.object.control.CommandWithListReference;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.server.model.ByteBlowerServerModelPackage;
import com.excentis.products.byteblower.server.model.EByteBlowerServerObject;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import com.excentis.products.byteblower.server.model.PhysicalInterface;
import com.excentis.products.byteblower.server.model.PhysicalServer;
import com.excentis.products.byteblower.server.model.ServerLinkStatus;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Version;

public final class PhysicalServerController
extends AbstractServerController<PhysicalServer>
implements PhysicalServerReader {
    private PhysicalServerReader reader = null;

    public PhysicalServerController(PhysicalServer myPhysicalServer) {
        super(myPhysicalServer);
    }

    private PhysicalServerReader getReader() {
        if (this.reader == null) {
            this.reader = ReaderFactory.create((PhysicalServer)((PhysicalServer)this.getObject()));
        }
        return this.reader;
    }

    public boolean hasPhysicalServer(PhysicalServer physicalServer) {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            return myPhysicalServer == physicalServer;
        }
        return false;
    }

    private static PhysicalServer createEmptyPhysicalServer() {
        return EByteBlowerServerObjectController.getByteBlowerServerModelFactory().createPhysicalServer();
    }

    public static PhysicalServer create() {
        PhysicalServer physicalServer = PhysicalServerController.createEmptyPhysicalServer();
        return physicalServer;
    }

    public PhysicalConfigurationController getPhysicalConfigurationController() {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            return new PhysicalConfigurationController(myPhysicalServer.getPhysicalConfiguration());
        }
        return null;
    }

    @Override
    public String getLocalName() {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            return myPhysicalServer.getLocalName();
        }
        return null;
    }

    public String getAddress() {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            return myPhysicalServer.getAddress();
        }
        return null;
    }

    public final PhysicalConfigurationTransfer getPhysicalConfigurationTransfer() {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            String myAddress = myPhysicalServer.getAddress();
            return new PhysicalConfigurationTransfer(myAddress, null, null);
        }
        return null;
    }

    public static final boolean allowOverridePortState(ServerLinkStatus pendingServerStatus) {
        return pendingServerStatus == ServerLinkStatus.ONLINE;
    }

    @Override
    public void setCurrentUsers(List<String> newCurrentUsers) {
        PhysicalServer myPhysicalServer = (PhysicalServer)this.getObject();
        if (myPhysicalServer != null) {
            myPhysicalServer.setCurrentUsers((EList)new BasicEList(newCurrentUsers));
        }
    }

    private final PhysicalInterface getPhysicalInterface(List<PhysicalInterface> physicalInterfaces, String physicalInterfaceId) {
        for (PhysicalInterface physicalInterface : physicalInterfaces) {
            if (!physicalInterface.getId().equals(physicalInterfaceId)) continue;
            return physicalInterface;
        }
        return null;
    }

    private final PhysicalInterface getPhysicalInterface(String physicalInterfaceId) {
        EList<PhysicalInterface> myPhysicalInterfaces = this.getPhysicalInterfaces();
        if (myPhysicalInterfaces != null) {
            return this.getPhysicalInterface((List<PhysicalInterface>)myPhysicalInterfaces, physicalInterfaceId);
        }
        return null;
    }

    public final PhysicalInterfaceController getPhysicalInterfaceController(String physicalInterfaceId) {
        PhysicalInterface physicalInterface = this.getPhysicalInterface(physicalInterfaceId);
        if (physicalInterface != null) {
            return new PhysicalInterfaceController(physicalInterface);
        }
        return null;
    }

    public List<PhysicalInterfaceController> getPhysicalInterfaceControllers() {
        EList<PhysicalInterface> myPhysicalInterfaces = this.getPhysicalInterfaces();
        if (myPhysicalInterfaces != null) {
            ArrayList<PhysicalInterfaceController> physicalInterfaceControllers = new ArrayList<PhysicalInterfaceController>(myPhysicalInterfaces.size());
            for (PhysicalInterface physicalInterface : myPhysicalInterfaces) {
                physicalInterfaceControllers.add(new PhysicalInterfaceController(physicalInterface));
            }
            return physicalInterfaceControllers;
        }
        return null;
    }

    private EReference getPhysicalInterfaceEReference() {
        return ByteBlowerServerModelPackage.Literals.PHYSICAL_SERVER__PHYSICAL_INTERFACE;
    }

    public final Command createAddCommand(PhysicalInterface physicalInterface) {
        return this.createAddCommand((EStructuralFeature)this.getPhysicalInterfaceEReference(), physicalInterface);
    }

    @Override
    public ServerLinkStatus getServerLinkStatus() {
        return this.getReader().getServerLinkStatus();
    }

    @Override
    public PhysicalDockable getPhysicalDockable(ByteBlowerGuiPortConfigurationReader portConfigReader) {
        return this.getReader().getPhysicalDockable(portConfigReader);
    }

    public List<PhysicalInterfaceReader> getPhysicalInterfaceReaders() {
        return this.getReader().getPhysicalInterfaceReaders();
    }

    public EList<PhysicalInterface> getPhysicalInterfaces() {
        return this.getReader().getPhysicalInterfaces();
    }

    public PhysicalInterfaceReader getPhysicalInterfaceReader(String interfaceId) {
        return this.getReader().getPhysicalInterfaceReader(interfaceId);
    }

    public final CommandWithPhysicalInterfaceListReference addPhysicalInterface(String interfaceId) {
        PhysicalInterface physicalInterface = PhysicalInterfaceController.create();
        physicalInterface.setId(interfaceId);
        Command addCommand = this.createAddCommand(physicalInterface);
        PhysicalInterfaceController controller = ControllerFactory.create(physicalInterface);
        UniqueEList controllers = new UniqueEList();
        controllers.add((Object)controller);
        return new CommandWithPhysicalInterfaceListReference(addCommand, (List<PhysicalInterfaceController>)controllers);
    }

    public int getNofInterfaces() {
        return this.getReader().getNofInterfaces();
    }

    public Command deletePhysicalInterface(PhysicalInterface physicalInterface) {
        return this.createRemoveCommand((EStructuralFeature)this.getPhysicalInterfaceEReference(), (EByteBlowerServerObject)physicalInterface);
    }

    @Override
    public Command selfDestroy() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.undock());
        compound.appendCommand(this.delete());
        return compound.getCompoundCommand();
    }

    @Override
    public Command undock() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (PhysicalInterfaceController controller : this.getPhysicalInterfaceControllers()) {
            compound.appendCommand(controller.undock());
        }
        return compound.getCompoundCommand();
    }

    public List<DockedByteBlowerPortReader> getAllDockedPortReaders() {
        return this.getReader().getAllDockedPortReaders();
    }

    public List<DockedByteBlowerPortController> getAllDockedPortControllers() {
        ArrayList<DockedByteBlowerPortController> controllers = new ArrayList<DockedByteBlowerPortController>();
        List<PhysicalInterfaceController> interfaceControllers = this.getPhysicalInterfaceControllers();
        for (PhysicalInterfaceController controller : interfaceControllers) {
            controllers.addAll(controller.getAllDockedPortControllers());
        }
        return controllers;
    }

    @Override
    public Command refreshPorts() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (PhysicalInterfaceController controller : this.getPhysicalInterfaceControllers()) {
            compound.appendCommand(controller.refreshPorts());
        }
        return compound.getCompoundCommand();
    }

    @Override
    public Version getLatestVersion() {
        return this.getReader().getLatestVersion();
    }

    @Override
    public Command setLinkStatusUnknown() {
        CompoundCommandController compound = CompoundCommandController.createInstance();
        compound.appendCommand(this.setServerLinkStatus(ServerLinkStatus.UNKNOWN));
        for (PhysicalInterfaceController controller : this.getPhysicalInterfaceControllers()) {
            compound.appendCommand(controller.setLinkStatusUnknown());
        }
        return compound.getCompoundCommand();
    }

    public static final class CommandWithPhysicalInterfaceListReference
    extends CommandWithListReference<PhysicalInterfaceController> {
        private CommandWithPhysicalInterfaceListReference(Command myCommand, List<PhysicalInterfaceController> myPhysicalInterfaceReference) {
            super(myCommand, myPhysicalInterfaceReference);
        }
    }
}

