/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.DhcpGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.DhcpReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class DhcpItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int COLUMN_DHCP_NAME = 0;
    public static final int COLUMN_DHCP_Initial_Discover_Timeout = 1;
    public static final int COLUMN_DHCP_Maximum_Discover_Retries = 2;
    public static final int COLUMN_DHCP_Initial_Request_Timeout = 3;
    public static final int COLUMN_DHCP_Maximum_Request_Retries = 4;
    public static final int COLUMN_DHCP_Retransmission_Policy = 5;

    public DhcpItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addMaximumDiscoverRetriesPropertyDescriptor(object);
            this.addInitialDiscoverTimeoutPropertyDescriptor(object);
            this.addMaximumRequestRetriesPropertyDescriptor(object);
            this.addInitialRequestTimeoutPropertyDescriptor(object);
            this.addRetransmissionPolicyPropertyDescriptor(object);
            this.addIpv4ConfigurationsPropertyDescriptor(object);
            this.addIpv6ConfigurationsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addMaximumDiscoverRetriesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_MaximumDiscoverRetries_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_MaximumDiscoverRetries_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_DISCOVER_RETRIES, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addInitialDiscoverTimeoutPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_InitialDiscoverTimeout_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_InitialDiscoverTimeout_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_DISCOVER_TIMEOUT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addMaximumRequestRetriesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_MaximumRequestRetries_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_MaximumRequestRetries_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_REQUEST_RETRIES, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addInitialRequestTimeoutPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_InitialRequestTimeout_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_InitialRequestTimeout_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_REQUEST_TIMEOUT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRetransmissionPolicyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_RetransmissionPolicy_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_RetransmissionPolicy_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__RETRANSMISSION_POLICY, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addIpv4ConfigurationsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_ipv4Configurations_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_ipv4Configurations_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__IPV4_CONFIGURATIONS, true, false, true, null, null, null));
    }

    protected void addIpv6ConfigurationsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dhcp_ipv6Configurations_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dhcp_ipv6Configurations_feature", "_UI_Dhcp_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__IPV6_CONFIGURATIONS, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Dhcp"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return ((Dhcp)object).getName();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Dhcp.class)) {
            case 0: {
                Dhcp dhcp = (Dhcp)notification.getNotifier();
                for (Ipv4Configuration ipv4Configuration : dhcp.getIpv4Configurations()) {
                    ByteBlowerGuiPort port = (ByteBlowerGuiPort)ipv4Configuration.eContainer();
                    port.setStatusIsKnown(Boolean.FALSE);
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        Dhcp dhcp = (Dhcp)object;
        DhcpReader reader = ReaderFactory.create((Dhcp)dhcp);
        switch (columnIndex) {
            case 0: {
                return reader.getName();
            }
            case 2: {
                return reader.getMaximumDiscoverRetriesString();
            }
            case 1: {
                return reader.getInitialDiscoverTimeoutString();
            }
            case 4: {
                return reader.getMaximumRequestRetriesString();
            }
            case 3: {
                return reader.getInitialRequestTimeoutString();
            }
            case 5: {
                return reader.getRetransmissionPolicyString();
            }
        }
        System.err.println("DhcpItemProvider#getValue() : invalid case !");
        return null;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            DhcpGuiReader reader = GuiReaderFactory.create((Dhcp)((Dhcp)object));
            return reader.getImage();
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(2, (EStructuralFeature)ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME);
            }
            case 1: {
                return new FeatureInfo(3, (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_DISCOVER_TIMEOUT);
            }
            case 3: {
                return new FeatureInfo(3, (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__INITIAL_REQUEST_TIMEOUT);
            }
            case 2: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_DISCOVER_RETRIES);
            }
            case 4: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__MAXIMUM_REQUEST_RETRIES);
            }
            case 5: {
                return new FeatureInfo(5, (EStructuralFeature)ByteblowerguimodelPackage.Literals.DHCP__RETRANSMISSION_POLICY);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }
}

