/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model.provider;

import com.excentis.products.byteblower.gui.model.reader.FlowGuiReader;
import com.excentis.products.byteblower.gui.model.reader.FlowMeasurementGuiReader;
import com.excentis.products.byteblower.gui.model.reader.factory.GuiReaderFactory;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.provider.EByteBlowerObjectItemProvider;
import com.excentis.products.byteblower.model.provider.FeatureInfo;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ScenarioReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.swt.graphics.Color;

public class FlowMeasurementItemProvider
extends EByteBlowerObjectItemProvider {
    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int COLUMN_STARTTIME = 0;
    public static final int COLUMN_FLOW = 1;
    public static final int COLUMN_DURATION = 2;
    public static final int COLUMN_NUMBER_OF_FRAMES = 3;

    public FlowMeasurementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addFlowPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addFlowPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FlowMeasurement_flow_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FlowMeasurement_flow_feature", "_UI_FlowMeasurement_type"), (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_START_EVENT);
            this.childrenFeatures.add(ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_STOP_EVENT);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FlowMeasurement"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String label = ((FlowMeasurement)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_FlowMeasurement_type") : String.valueOf(this.getString("_UI_FlowMeasurement_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FlowMeasurement.class)) {
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_START_EVENT, ByteblowerguimodelFactory.eINSTANCE.createScenarioFlowStartEvent()));
        newChildDescriptors.add(this.createChildParameter(ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_STOP_EVENT, ByteblowerguimodelFactory.eINSTANCE.createScenarioFlowStopEvent()));
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        FlowMeasurement flowMeasurement = (FlowMeasurement)object;
        FlowMeasurementGuiReader reader = GuiReaderFactory.create((FlowMeasurement)flowMeasurement);
        switch (columnIndex) {
            case 0: {
                return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)reader.getStartTime());
            }
            case 1: {
                return reader.getFlowString();
            }
            case 2: {
                return reader.getDurationString();
            }
            case 3: {
                return reader.getNumberOfFramesString();
            }
        }
        return null;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                FlowMeasurementGuiReader reader = GuiReaderFactory.create((FlowMeasurement)((FlowMeasurement)object));
                return reader.getImage();
            }
            case 1: {
                FlowMeasurementGuiReader reader = GuiReaderFactory.create((FlowMeasurement)((FlowMeasurement)object));
                FlowGuiReader flowReader = reader.getFlowGuiReader();
                return flowReader.getImage();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        FlowMeasurement measurement = (FlowMeasurement)element;
        Flow flow = measurement.getFlow();
        if (columnIndex == 1 && flow == null) {
            return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_ERROR();
        }
        return EByteBlowerObjectItemProvider.FOREGROUND_COLOR_OK;
    }

    @Override
    public Color getBackground(Object element, int columnIndex) {
        FlowMeasurement flowMeasurement = (FlowMeasurement)element;
        if (flowMeasurement.eContainer() == null) {
            return null;
        }
        Scenario scenario = flowMeasurement.getScenario();
        ScenarioReaderImpl scenarioReader = new ScenarioReaderImpl(scenario);
        FlowMeasurementReaderImpl flowMeasurementReader = new FlowMeasurementReaderImpl(flowMeasurement);
        if (scenario != null) {
            EList flowMeasurements = scenarioReader.getFlowMeasurements();
            boolean oddRowColor = false;
            HighResolutionCalendar time = flowMeasurementReader.getStartTime();
            HighResolutionCalendar testTime = null;
            for (FlowMeasurement otherFlowMeasurement : flowMeasurements) {
                FlowMeasurementReaderImpl otherFlowMeasurementReader = new FlowMeasurementReaderImpl(otherFlowMeasurement);
                HighResolutionCalendar otherTime = otherFlowMeasurementReader.getStartTime();
                if (testTime == null) {
                    testTime = otherTime;
                }
                if (testTime.equals((Object)time)) break;
                if (!otherTime.after((Object)testTime)) continue;
                oddRowColor = !oddRowColor;
                testTime = otherTime;
            }
            return oddRowColor ? EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ODD_ROW() : EByteBlowerObjectItemProvider.BACKGROUND_COLOR_EVEN_ROW;
        }
        System.err.println("FlowMeasurementItemProvider:getBackground on dangling FlowMeasurement");
        return EByteBlowerObjectItemProvider.BACKGROUND_COLOR_ERROR;
    }

    @Override
    public FeatureInfo getFeatureInfoOnColumn(Object object, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_START_EVENT);
            }
            case 1: {
                return new FeatureInfo(1, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW);
            }
            case 2: 
            case 3: {
                return new FeatureInfo(0, (EStructuralFeature)ByteblowerguimodelPackage.Literals.FLOW_MEASUREMENT__FLOW_STOP_EVENT);
            }
        }
        return super.getFeatureInfoOnColumn(object, columnIndex);
    }
}

