/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IgmpVersion implements Enumerator
{
    IGM_PV1_LITERAL(1, "IGMPv1", "IGMPv1"),
    IGM_PV2_LITERAL(2, "IGMPv2", "IGMPv2"),
    IGM_PV3_LITERAL(3, "IGMPv3", "IGMPv3");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int IGM_PV1 = 1;
    public static final int IGM_PV2 = 2;
    public static final int IGM_PV3 = 3;
    private static final IgmpVersion[] VALUES_ARRAY;
    public static final List<IgmpVersion> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IgmpVersion[]{IGM_PV1_LITERAL, IGM_PV2_LITERAL, IGM_PV3_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IgmpVersion get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IgmpVersion result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IgmpVersion getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IgmpVersion result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IgmpVersion get(int value) {
        switch (value) {
            case 1: {
                return IGM_PV1_LITERAL;
            }
            case 2: {
                return IGM_PV2_LITERAL;
            }
            case 3: {
                return IGM_PV3_LITERAL;
            }
        }
        return null;
    }

    private IgmpVersion(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

