/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PayloadUnit implements Enumerator
{
    BITS(0, "bits", "bits"),
    KBITS(1, "kbits", "kbits"),
    MBITS(2, "Mbits", "Mbits"),
    GBITS(3, "Gbits", "Gbits"),
    BYTES(4, "Bytes", "Bytes"),
    KBYTES(5, "KBytes", "KBytes"),
    MBYTES(6, "MBytes", "MBytes"),
    GBYTES(7, "GBytes", "GBytes");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int BITS_VALUE = 0;
    public static final int KBITS_VALUE = 1;
    public static final int MBITS_VALUE = 2;
    public static final int GBITS_VALUE = 3;
    public static final int BYTES_VALUE = 4;
    public static final int KBYTES_VALUE = 5;
    public static final int MBYTES_VALUE = 6;
    public static final int GBYTES_VALUE = 7;
    private static final PayloadUnit[] VALUES_ARRAY;
    public static final List<PayloadUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PayloadUnit[]{BITS, KBITS, MBITS, GBITS, BYTES, KBYTES, MBYTES, GBYTES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PayloadUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PayloadUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PayloadUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PayloadUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PayloadUnit get(int value) {
        switch (value) {
            case 0: {
                return BITS;
            }
            case 1: {
                return KBITS;
            }
            case 2: {
                return MBITS;
            }
            case 3: {
                return GBITS;
            }
            case 4: {
                return BYTES;
            }
            case 5: {
                return KBYTES;
            }
            case 6: {
                return MBYTES;
            }
            case 7: {
                return GBYTES;
            }
        }
        return null;
    }

    private PayloadUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

