/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TCPCongestionAvoidanceAlgorithm implements Enumerator
{
    SERVER_DEFAULT(0, "ServerDefault", "ServerDefault"),
    NONE(1, "None", "None"),
    NEW_RENO(2, "New Reno", "NewReno"),
    SACK(3, "SACK", "SACK"),
    NEW_RENO_WITH_CUBIC(4, "New Reno with CUBIC", "NewReno (with cubic)"),
    SACK_WITH_CUBIC(5, "SACK with CUBIC", "SACK (with cubic)");

    public static final String copyright = "Copyright 2005 - 2023 Excentis nv";
    public static final int SERVER_DEFAULT_VALUE = 0;
    public static final int NONE_VALUE = 1;
    public static final int NEW_RENO_VALUE = 2;
    public static final int SACK_VALUE = 3;
    public static final int NEW_RENO_WITH_CUBIC_VALUE = 4;
    public static final int SACK_WITH_CUBIC_VALUE = 5;
    private static final TCPCongestionAvoidanceAlgorithm[] VALUES_ARRAY;
    public static final List<TCPCongestionAvoidanceAlgorithm> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TCPCongestionAvoidanceAlgorithm[]{SERVER_DEFAULT, NONE, NEW_RENO, SACK, NEW_RENO_WITH_CUBIC, SACK_WITH_CUBIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TCPCongestionAvoidanceAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TCPCongestionAvoidanceAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TCPCongestionAvoidanceAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TCPCongestionAvoidanceAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TCPCongestionAvoidanceAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return SERVER_DEFAULT;
            }
            case 1: {
                return NONE;
            }
            case 2: {
                return NEW_RENO;
            }
            case 3: {
                return SACK;
            }
            case 4: {
                return NEW_RENO_WITH_CUBIC;
            }
            case 5: {
                return SACK_WITH_CUBIC;
            }
        }
        return null;
    }

    private TCPCongestionAvoidanceAlgorithm(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

