/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.project;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.project.ByteBlowerResource;
import com.excentis.products.byteblower.project.ByteBlowerResourceFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ByteBlowerResourceController {
    private static long idCounter = 0L;
    private static Object lock = new Object();
    private static ByteBlowerResourceController instance = null;
    private ByteBlowerResourceFactoryImpl resourceFactory = new ByteBlowerResourceFactoryImpl();
    private ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
    private static final String BBP_FILE_EXTENSION = "bbp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getUniqueId() {
        Object object = lock;
        synchronized (object) {
            return ++idCounter;
        }
    }

    public static ByteBlowerResourceController getInstance() {
        if (instance == null) {
            instance = new ByteBlowerResourceController();
        }
        return instance;
    }

    public ByteBlowerResourceController() {
        this.resourceSet.getPackageRegistry().put((Object)"http:///com.excentis.products.byteblower.gui.model.ecore", (Object)ByteblowerguimodelPackage.eINSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EList<ByteBlowerResource> getByteBlowerProjectResources() {
        UniqueEList byteBlowerProjectResources = new UniqueEList();
        Object object = lock;
        synchronized (object) {
            for (Resource resource : this.getResources()) {
                if (!(resource instanceof ByteBlowerResource)) continue;
                byteBlowerProjectResources.add((Object)((ByteBlowerResource)resource));
            }
        }
        return byteBlowerProjectResources;
    }

    private EList<Resource> getResources() {
        return this.resourceSet.getResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(ByteBlowerResource resource) {
        Object object = lock;
        synchronized (object) {
            this.getResources().add((Object)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResource(ByteBlowerResource resource) {
        Object object = lock;
        synchronized (object) {
            this.getResources().remove((Object)resource);
        }
    }

    private EditingDomain getEditingDomain() {
        return ByteBlowerEditingDomainProvider.getEditingDomain();
    }

    private URI getResourceUri(String uriString) {
        return this.resourceFactory.getUri(uriString);
    }

    private ByteBlowerResource createOrGet(URI uri) {
        ByteBlowerResource resource = this.getResource(uri);
        if (resource != null) {
            return resource;
        }
        resource = this.resourceFactory.createResource(uri);
        this.addResource(resource);
        return resource;
    }

    protected ByteBlowerResource getAddedResource(ByteBlowerProject project) {
        for (ByteBlowerResource byteBlowerResource : this.getByteBlowerProjectResources()) {
            if (project != byteBlowerResource.getByteBlowerProject()) continue;
            return byteBlowerResource;
        }
        return null;
    }

    private ByteBlowerResource getResource(URI uri) {
        for (ByteBlowerResource byteBlowerResource : this.getByteBlowerProjectResources()) {
            String uriString = uri.toFileString();
            String resourceString = byteBlowerResource.getURI().toFileString();
            if (resourceString.compareTo(uriString) != 0) continue;
            return byteBlowerResource;
        }
        return null;
    }

    public ByteBlowerResource getResource(String uriString) {
        return this.getResource(this.getResourceUri(uriString));
    }

    public String createFilename(String projectName, String path) {
        URI newFileUri = URI.createFileURI((String)path);
        newFileUri = newFileUri.appendSegment(projectName);
        newFileUri = newFileUri.appendFileExtension(BBP_FILE_EXTENSION);
        return newFileUri.toFileString();
    }

    public boolean create(String fileName, String projectName, String authorName, IProgressMonitor progressMonitor) {
        boolean result = true;
        try {
            try {
                progressMonitor.beginTask("Creating project " + projectName, 4);
                progressMonitor.worked(1);
                ByteBlowerResource newResource = this.resourceFactory.createResource(fileName, projectName, authorName);
                progressMonitor.worked(1);
                this.addResource(newResource);
                progressMonitor.worked(1);
                this.save(newResource, progressMonitor);
                progressMonitor.worked(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Error while creating project : " + exception.getMessage());
                result = false;
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return result;
    }

    public String openXmlProject(String xmlProject, IProgressMonitor progressMonitor) {
        String xmlResourceUri = "emf://com.excentis.products.byteblower.project/resource/transient/id/" + ByteBlowerResourceController.getUniqueId();
        URI uri = URI.createFileURI((String)xmlResourceUri);
        ByteBlowerResource resource = this.createOrGet(uri);
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xmlProject.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("UnsupportedEncodingException Error : " + e);
            e.printStackTrace();
            return null;
        }
        try {
            resource.load(inputStream, Collections.emptyMap());
        }
        catch (IOException e) {
            this.close(resource);
            throw new RuntimeException("Could not load project", e);
        }
        this.openProjectResource(resource, progressMonitor);
        return xmlResourceUri;
    }

    public ByteBlowerResource openProject(String filename, IProgressMonitor progressMonitor) {
        URI resourceUri = this.getResourceUri(filename);
        ByteBlowerResource resource = this.createOrGet(resourceUri);
        if (resource == null) {
            throw new RuntimeException("Could not create project resource for " + filename);
        }
        try {
            resource.load(Collections.emptyMap());
        }
        catch (IOException e) {
            this.close(resource);
            throw new RuntimeException("Could not load project", e);
        }
        this.openProjectResource(resource, progressMonitor);
        return resource;
    }

    private final ByteBlowerProject openProjectResource(ByteBlowerResource resource, IProgressMonitor progressMonitor) {
        ByteBlowerProject openedProject = null;
        try {
            try {
                progressMonitor.worked(1);
                resource.updateProject();
                progressMonitor.worked(1);
                Diagnostic diagnostic = this.validate(resource);
                if (diagnostic != Diagnostic.OK_INSTANCE) {
                    throw new RuntimeException("Invalid project content", new IOException(this.gatherDiagnosticInfo(diagnostic)));
                }
                progressMonitor.worked(1);
                openedProject = resource.getByteBlowerProject();
            }
            catch (Exception t) {
                t.printStackTrace();
                this.close(resource);
                openedProject = null;
                throw t;
            }
        }
        finally {
            progressMonitor.done();
        }
        return openedProject;
    }

    public void close(ByteBlowerResource resource) {
        if (resource != null) {
            resource.unload();
            this.removeResource(resource);
        }
    }

    private String gatherDiagnosticInfo(Diagnostic diagnostic) {
        return this.gatherDiagnosticInfo(diagnostic, "");
    }

    private String gatherDiagnosticInfo(Diagnostic diagnostic, String indent) {
        String errorMessage = diagnostic.getMessage();
        for (Diagnostic child : diagnostic.getChildren()) {
            errorMessage = String.valueOf(errorMessage) + "\n" + indent + this.gatherDiagnosticInfo(child, String.valueOf(indent) + "  ");
        }
        return errorMessage;
    }

    protected void save(ByteBlowerResource resource, IProgressMonitor progressMonitor) {
        if (resource == null) {
            throw new IllegalArgumentException("Cannot save null resource");
        }
        try {
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
                resource.save(options);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not save project", e);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private Diagnostic validate(ByteBlowerResource resource) {
        for (EObject eObject : resource.getContents()) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            return diagnostic;
        }
        ByteBlowerProject project = resource.getByteBlowerProject();
        if (project.getAuthor() == null) {
            project.setAuthor("Unknown");
        }
        if (project.getName() == null) {
            String lastUriSegment = resource.getURI().lastSegment();
            project.setName(lastUriSegment);
        }
        return Diagnostic.OK_INSTANCE;
    }
}

