/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnit;
import com.excentis.products.byteblower.report.generator.core.parameters.DataRateUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LatencyPatternParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LatencyUnitParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.LossLevelParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputPatternParameter;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputType;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ReportPreferences
implements ReportPreferencesInterface {
    private Set<ReportOutputFormat> outputFormats = new HashSet<ReportOutputFormat>();
    private LossLevelParameter warningLossLevel;
    private LossLevelParameter errorLossLevel;
    private DataRateUnitParameter dataRateUnit;
    private ThroughputTypeParameter throughputType;
    private ThroughputPatternParameter throughputPattern;
    private LatencyPatternParameter latencyPattern;
    private String outputLocation;
    private String apiKey = "";
    private String uploadLocation = "";
    private LatencyUnitParameter timeUnit;

    public ReportPreferences(ByteBlowerProject project, String outputLocation) {
        this.loadGenericPreferences();
        if (project == null) {
            this.loadGeneralPreferences();
        } else {
            this.loadPreferencesFromProject(project);
        }
        if (outputLocation != null) {
            this.outputLocation = outputLocation;
        }
    }

    public ReportPreferences(ByteBlowerProject project) {
        this(project, null);
    }

    public ReportPreferences() {
        this(null, null);
    }

    public ReportPreferences(String outputLocation) {
        this(null, outputLocation);
    }

    public Set<ReportOutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public void setOutputFormats(Collection<ReportOutputFormat> formats) {
        HashSet<ReportOutputFormat> copied = new HashSet<ReportOutputFormat>(formats);
        this.outputFormats.clear();
        this.outputFormats.addAll(copied);
    }

    public LossLevelParameter getWarningLossLevel() {
        return this.warningLossLevel;
    }

    public LossLevelParameter getErrorLossLevel() {
        return this.errorLossLevel;
    }

    public DataRateUnitParameter getDataRateUnit() {
        return this.dataRateUnit;
    }

    public ThroughputTypeParameter getThroughputType() {
        return this.throughputType;
    }

    public ThroughputPatternParameter getThroughputPattern() {
        return this.throughputPattern;
    }

    public LatencyPatternParameter getLatencyPattern() {
        return this.latencyPattern;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public LatencyUnitParameter getLatencyUnit() {
        return this.timeUnit;
    }

    private void loadGenericPreferences() {
        this.outputLocation = ByteBlowerPreferences.getArchiveLocation();
        if (ByteBlowerPreferences.hasApiKey()) {
            this.setCloudConfig(ByteBlowerPreferences.getApiKey(), ByteBlowerPreferences.getExcentisCloudUrl());
        }
    }

    private void loadGeneralPreferences() {
        this.setWarningLossLevel(ByteBlowerPreferences.getWarningLossLevel());
        this.setErrorLossLevel(ByteBlowerPreferences.getErrorLossLevel());
        this.setThroughputType(ByteBlowerPreferences.getThroughputType());
        this.setDataRateUnit(ByteBlowerPreferences.getThroughputUnit());
        this.setThroughputPattern(ByteBlowerPreferences.getNumberOfDecimals());
        this.setLatencyPattern(ByteBlowerPreferences.getNumberOfLatencyDecimals());
        this.setUnit(ByteBlowerPreferences.getLatencyUnit());
        this.generateOutputFormats();
    }

    private void loadPreferencesFromProject(ByteBlowerProject project) {
        this.setErrorLossLevel(project.getErrorLossLevel());
        this.setWarningLossLevel(project.getWarningLossLevel());
        this.setThroughputType(project.getThroughputType());
        this.setDataRateUnit(project.getThroughputUnit());
        this.setThroughputPattern(project.getNumberOfDecimals());
        this.setLatencyPattern(project.getNumberOfLatencyDecimals());
        this.setUnit(project.getLatencyUnit());
        this.generateOutputFormats(project);
    }

    private void generateOutputFormats(ByteBlowerProject project) {
        if (project.isReportOutputToCsv()) {
            this.outputFormats.add(ReportOutputFormat.csv);
        }
        if (project.isReportOutputToExcel()) {
            this.outputFormats.add(ReportOutputFormat.xlsx);
        }
        if (project.isReportOutputToDynamicHtml()) {
            this.outputFormats.add(ReportOutputFormat.dynamicHtml);
        }
        if (project.isReportOutputToHtml()) {
            this.outputFormats.add(ReportOutputFormat.html);
        }
        if (project.isReportOutputToDeprecatedHtml()) {
            this.outputFormats.add(ReportOutputFormat.deprecatedjasperhtml);
        }
        if (project.isReportOutputToPdf()) {
            this.outputFormats.add(ReportOutputFormat.pdf);
        }
        if (project.isReportOutputToJson()) {
            this.outputFormats.add(ReportOutputFormat.json);
        }
        if (this.shouldDoCloudUpload()) {
            this.outputFormats.add(ReportOutputFormat.cloud);
        }
    }

    private boolean shouldDoCloudUpload() {
        return !this.apiKey.isBlank() && !this.uploadLocation.isBlank();
    }

    private void generateOutputFormats() {
        if (ByteBlowerPreferences.getOutputToCsv()) {
            this.outputFormats.add(ReportOutputFormat.csv);
        }
        if (ByteBlowerPreferences.getOutputToExcel()) {
            this.outputFormats.add(ReportOutputFormat.xlsx);
        }
        if (ByteBlowerPreferences.getOutputToDynamicHtml()) {
            this.outputFormats.add(ReportOutputFormat.dynamicHtml);
        }
        if (ByteBlowerPreferences.getOutputToHtml()) {
            this.outputFormats.add(ReportOutputFormat.html);
        }
        if (ByteBlowerPreferences.isReportOutputToDeprecatedHtml()) {
            this.outputFormats.add(ReportOutputFormat.deprecatedjasperhtml);
        }
        if (ByteBlowerPreferences.getOutputToPdf()) {
            this.outputFormats.add(ReportOutputFormat.pdf);
        }
        if (ByteBlowerPreferences.getOutputToJson()) {
            this.outputFormats.add(ReportOutputFormat.json);
        }
        if (this.shouldDoCloudUpload()) {
            this.outputFormats.add(ReportOutputFormat.cloud);
        }
    }

    private void setThroughputType(com.excentis.products.byteblower.model.ThroughputType type) {
        this.setThroughputType(type.getValue());
    }

    private void setThroughputType(int unit) {
        switch (unit) {
            case 0: {
                this.throughputType = new ThroughputTypeParameter(ThroughputType.FRAME_ONLY);
                break;
            }
            case 1: {
                this.throughputType = new ThroughputTypeParameter(ThroughputType.FRAME_AND_FCS);
                break;
            }
            case 2: {
                this.throughputType = new ThroughputTypeParameter(ThroughputType.FRAME_AND_ALL_OTHER_FIELDS);
                break;
            }
            default: {
                this.throughputType = new ThroughputTypeParameter(ThroughputType.FRAME_ONLY);
            }
        }
    }

    private void setDataRateUnit(com.excentis.products.byteblower.model.DataRateUnit throughputUnit) {
        this.setDataRateUnit(throughputUnit.getValue());
    }

    private void setThroughputPattern(int numberOfDecimals) {
        this.throughputPattern = new ThroughputPatternParameter(numberOfDecimals);
    }

    private void setLatencyPattern(int numberOfDecimals) {
        this.latencyPattern = new LatencyPatternParameter(numberOfDecimals);
    }

    private void setDataRateUnit(int throughputUnit) {
        switch (throughputUnit) {
            case 0: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.BPS);
                break;
            }
            case 4: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.BYTESPS);
                break;
            }
            case 1: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.KBPS);
                break;
            }
            case 5: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.KBYTESPS);
                break;
            }
            case 2: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.MBPS);
                break;
            }
            case 6: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.MBYTESPS);
                break;
            }
            case 3: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.GBPS);
                break;
            }
            case 7: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.GBYTESPS);
                break;
            }
            default: {
                this.dataRateUnit = new DataRateUnitParameter(DataRateUnit.BPS);
            }
        }
    }

    private void setErrorLossLevel(String errorLossLevel) {
        this.errorLossLevel = LossLevelParameter.errorLevel((double)Double.parseDouble(errorLossLevel));
    }

    private void setWarningLossLevel(String warningLossLevel) {
        this.warningLossLevel = LossLevelParameter.warningLevel((double)Double.parseDouble(warningLossLevel));
    }

    private void setUnit(int unit) {
        switch (unit) {
            case 14: {
                this.timeUnit = new LatencyUnitParameter(LatencyUnit.MILLISECONDS);
                break;
            }
            case 17: {
                this.timeUnit = new LatencyUnitParameter(LatencyUnit.MICROSECONDS);
                break;
            }
            case 18: {
                this.timeUnit = new LatencyUnitParameter(LatencyUnit.NANOSECONDS);
                break;
            }
            default: {
                this.timeUnit = new LatencyUnitParameter(LatencyUnit.MICROSECONDS);
            }
        }
    }

    public void setCloudConfig(String apiKey, String uploadLocation) {
        this.apiKey = apiKey;
        this.uploadLocation = uploadLocation;
        if (this.shouldDoCloudUpload()) {
            this.outputFormats.add(ReportOutputFormat.cloud);
        } else {
            this.outputFormats.remove(ReportOutputFormat.cloud);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getUploadUrl() {
        return this.uploadLocation;
    }
}

