/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.dataprovider.data.entities;

import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Entity
@Table(name="report_generation")
public class ReportGeneration
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="testdata_reference_id", nullable=false)
    private TestDataReference testDataReference;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="generation_time", nullable=false)
    private Date generationTime;
    @OneToMany(mappedBy="reportGeneration")
    private Set<Report> reports;
    @Transient
    private static List<PostUpdateListener> postUpdateListeners = new ArrayList<PostUpdateListener>();

    public ReportGeneration(TestDataReference testDataReference, Date generationTime) {
        if (testDataReference == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'testDataReference' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (generationTime == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'generationTime' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.testDataReference = testDataReference;
        this.testDataReference.addReportGeneration(this);
        this.generationTime = generationTime;
        this.reports = new HashSet<Report>();
    }

    ReportGeneration() {
    }

    public TestDataReference getTestDataReference() {
        return this.testDataReference;
    }

    public Date getGenerationTime() {
        return this.generationTime;
    }

    public Set<Report> getReports() {
        return Collections.unmodifiableSet(this.reports);
    }

    public void addReport(Report report) {
        if (report == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding entity property 'report' of type " + this.getClass().getSimpleName());
        }
        if (!this.reports.contains(report)) {
            this.reports.add(report);
        }
    }

    public static void addPostPersistListener(PostUpdateListener listener) {
        postUpdateListeners.add(listener);
    }

    public static void removePostPersistListener(PostUpdateListener listener) {
        postUpdateListeners.remove(listener);
    }

    public static interface PostUpdateListener {
        public void postUpdate(ReportGeneration var1);
    }
}

