/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.dataprovider.data.entities;

import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Tag;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.dataprovider.data.enums.PersistenceType;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestStatus;
import com.excentis.products.byteblower.results.dataprovider.data.enums.TestType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

@Entity
@Table(name="testdata_reference")
public class TestDataReference
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="project_name", length=21844)
    private String projectName = null;
    @Column(name="project_author", length=21844)
    private String projectAuthor = null;
    @Column(name="project_version", length=100)
    private String projectVersion = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="test_type", length=40)
    private TestType testType = null;
    @Column(name="test_name", length=21844)
    private String testName = null;
    @Column(name="testrun_title", length=21844)
    private String testRunTitle = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="testrun_status", length=40)
    private TestStatus status = TestStatus.CREATED;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="testrun_start_time")
    private Date startTime = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="testrun_end_time")
    private Date endTime = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="persistence_type", length=40)
    private PersistenceType persistenceType = null;
    @Column(name="persistence_url", length=21844)
    private String persistenceUrl = null;
    @OneToMany(mappedBy="testDataReference")
    private List<ReportGeneration> reportGenerations = new ArrayList<ReportGeneration>();
    @OneToMany(mappedBy="testDataReference")
    private List<Tag> tags = new ArrayList<Tag>();
    @Transient
    private static List<PostPersistListener> postPersistListeners = new ArrayList<PostPersistListener>();

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        if (this.projectName != null) {
            throw new IllegalStateException("Cannot modify entity property 'projectName' once it has been set");
        }
        if (projectName == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'projectName' of type " + this.getClass().getSimpleName());
        }
        this.projectName = projectName;
    }

    public String getProjectAuthor() {
        return this.projectAuthor;
    }

    public void setProjectAuthor(String projectAuthor) {
        if (this.projectAuthor != null) {
            throw new IllegalStateException("Cannot modify entity property 'projectAuthor' once it has been set");
        }
        if (projectAuthor == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'projectAuthor' of type " + this.getClass().getSimpleName());
        }
        this.projectAuthor = projectAuthor;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        if (this.projectVersion != null) {
            throw new IllegalStateException("Cannot modify entity property 'projectVersion' once it has been set");
        }
        if (projectVersion == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'projectVersion' of type " + this.getClass().getSimpleName());
        }
        this.projectVersion = projectVersion;
    }

    public TestType getTestType() {
        return this.testType;
    }

    public void setTestType(TestType testType) {
        if (this.testType != null) {
            throw new IllegalStateException("Cannot modify entity property 'testType' once it has been set");
        }
        if (testType == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'testType' of type " + this.getClass().getSimpleName());
        }
        this.testType = testType;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        if (this.testName != null) {
            throw new IllegalStateException("Cannot modify entity property 'testName' once it has been set");
        }
        if (testName == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'testName' of type " + this.getClass().getSimpleName());
        }
        this.testName = testName;
    }

    public String getTestRunTitle() {
        return this.testRunTitle;
    }

    public void setTestRunTitle(String testRunTitle) {
        if (testRunTitle == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'testRunTitle' of type " + this.getClass().getSimpleName());
        }
        this.testRunTitle = testRunTitle;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'status' of type " + this.getClass().getSimpleName());
        }
        this.status = status;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (this.startTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'startTime' once it has been set");
        }
        if (startTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'startTime' of type " + this.getClass().getSimpleName());
        }
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        if (endTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'endTime' of type " + this.getClass().getSimpleName());
        }
        this.endTime = endTime;
    }

    public PersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    public void setPersistenceType(PersistenceType persistenceType) {
        if (this.persistenceType != null) {
            throw new IllegalStateException("Cannot modify entity property 'persistenceType' once it has been set");
        }
        if (persistenceType == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'persistenceType' of type " + this.getClass().getSimpleName());
        }
        this.persistenceType = persistenceType;
    }

    public String getPersistenceUrl() {
        return this.persistenceUrl;
    }

    public void setPersistenceUrl(String persistenceUrl) {
        if (this.persistenceUrl != null) {
            throw new IllegalStateException("Cannot modify entity property 'persistenceUrl' once it has been set");
        }
        if (persistenceUrl == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'persistenceUrl' of type " + this.getClass().getSimpleName());
        }
        this.persistenceUrl = persistenceUrl;
    }

    public List<ReportGeneration> getReportGenerations() {
        return Collections.unmodifiableList(this.reportGenerations);
    }

    void addReportGeneration(ReportGeneration reportGeneration) {
        if (this.reportGenerations == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding report generation to entity property 'reportGenerations' of type " + this.getClass().getSimpleName());
        }
        this.reportGenerations.add(reportGeneration);
    }

    public List<Tag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    void addTag(Tag tag) {
        if (this.tags == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding tag to entity property 'tags' of type " + this.getClass().getSimpleName());
        }
        this.tags.add(tag);
    }

    public Object clone() throws CloneNotSupportedException {
        TestDataReference clone = (TestDataReference)super.clone();
        return clone;
    }

    public String toString() {
        return "TestDataItem  - id: " + (this.getId() == null ? "NULL" : this.getId()) + " - projectName: " + (this.getProjectName() == null ? "NULL" : this.getProjectName()) + " - projectauthor: " + (this.getProjectAuthor() == null ? "NULL" : this.getProjectAuthor()) + " - projectversion: " + (this.getProjectVersion() == null ? "NULL" : this.getProjectVersion()) + " - testType: " + (this.getTestType() == null ? "NULL" : this.getTestType()) + " - testName: " + (this.getTestName() == null ? "NULL" : this.getTestName()) + " - status: " + (this.getStatus() == null ? "NULL" : this.getStatus()) + " - startTime: " + (this.getStartTime() == null ? "NULL" : this.getStartTime()) + " - endTime: " + (this.getEndTime() == null ? "NULL" : this.getEndTime()) + " - persistenceType: " + (this.getPersistenceType() == null ? "NULL" : this.getPersistenceType()) + " - persistenceUrl: " + (this.getPersistenceUrl() == null ? "NULL" : this.getPersistenceUrl());
    }

    public static void addPostPersistListener(PostPersistListener listener) {
        postPersistListeners.add(listener);
    }

    public static void removePostPersistListener(PostPersistListener listener) {
        postPersistListeners.remove(listener);
    }

    @PostPersist
    @PostUpdate
    public void postPersist() {
        for (PostPersistListener listener : postPersistListeners) {
            listener.postPersist(this);
        }
    }

    private String getTestDbfilename() {
        String url = this.getPersistenceUrl();
        String result = "";
        if (url != null) {
            String prefix = "jdbc:h2:file:";
            String suffix = ";MODE=MySQL;AUTO_SERVER=TRUE";
            if (url.startsWith(prefix) && url.endsWith(suffix)) {
                String dbLocation = url.substring(prefix.length(), url.length() - suffix.length());
                dbLocation = String.valueOf(dbLocation) + ".mv.db";
                result = dbLocation.replaceFirst("^~", Matcher.quoteReplacement(System.getProperty("user.home")));
            }
        }
        return result;
    }

    public long getFileSize() {
        String fileName = this.getTestDbfilename();
        Path filePath = Paths.get(fileName, new String[0]);
        long resultSize = 0L;
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                resultSize = Files.size(filePath);
            }
            catch (IOException e) {
                Logger.getGlobal().log(Level.WARNING, "Cant' access database file", e);
            }
        }
        return resultSize;
    }

    public String getTestDatabaseSize() {
        long size = this.getFileSize();
        if (0L == size) {
            return "";
        }
        double a_mbyte = 1000000.0;
        return String.format("%.02f Mbyte", (double)size / 1000000.0);
    }

    public static interface PostPersistListener {
        public void postPersist(TestDataReference var1);
    }
}

