/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Date;
import java.util.List;
import org.osgi.framework.Version;

class CongestionWindowSizeSuggestion
extends PostProcessor {
    private static final String WINDOW_SCALE_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/64/30/background-calculate-the-optimal-tcp-windowscale-value";
    private static final Version version = new Version(0, 0, 5);

    public CongestionWindowSizeSuggestion() {
        super("CongestionWindowSizeSuggestion", version);
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List tcpFlows = manager.getAllTcp(scenario);
        CumulativeSnapshotManager cumul = new CumulativeSnapshotManager(control);
        for (HttpFlowInstance flowInstance : tcpFlows) {
            TcpSessionSnapshot snap;
            HttpSession srcSession;
            HttpFlowInstanceReader reader = EntityReaderFactory.create((HttpFlowInstance)flowInstance);
            if (flowInstance.getDuration() == null || flowInstance.getClientHttpSession() == null || flowInstance.getRequestMethod() == null || (srcSession = reader.getSourceHttpSession()) == null) continue;
            String flowname = reader.getName();
            HttpSessionReader srcSessionReader = EntityReaderFactory.create((HttpSession)srcSession);
            TcpSession srcTcp = srcSession.getTcpSession();
            if (srcTcp == null || (snap = cumul.find(srcTcp)) == null || snap.getTxCounters() == null) continue;
            double estimatedRoundTrip = (double)(snap.getRoundTripTimeMinimum() + snap.getRoundTripTimeCurrent() + snap.getRoundTripTimeMinimum()) / 3.0;
            Long totalBytes = snap.getTxCounters().getBytesTotal();
            Long duration = srcSessionReader.getTxDurationNanoseconds();
            Integer windowScale = flowInstance.getFlowTemplate().getRxWindowScaleValue();
            if (totalBytes == null || windowScale == null) continue;
            long bytesInFlight = (1L << windowScale) * 65535L;
            double averageFlightBytes = (double)totalBytes.longValue() * estimatedRoundTrip / (double)duration.longValue();
            double ratio = averageFlightBytes / (double)Math.max(1L, bytesInFlight);
            if (!(ratio > 0.6)) continue;
            EventManager evt = new EventManager(control);
            String format = "The amount of bytes in flight is potentially limited by the receive window.\nFlow %s is better suited with a window scale of %s.\nClick here for more information.";
            String suggestion = String.format(format, flowname, Math.min(windowScale + 1, 8));
            FlowInstanceEvent event = new FlowInstanceEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, (FlowInstance)flowInstance);
            event.setKnowledgebaseLink(WINDOW_SCALE_ARTICLE);
            evt.persistIdEntity((BaseEntity)event);
        }
    }
}

