/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TagManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.Tag;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.Version;

class FBResultsTag
extends PostProcessor {
    private static final Version version = new Version(0, 0, 1);

    public FBResultsTag() {
        super("FBResultsTags", version);
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List fbFlows = manager.getAllFrameBlasting(scenario);
        HashSet<String> tagsToAdd = new HashSet<String>();
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            FbSource source = flowReader.getSource();
            if (source == null) continue;
            FbTrigger sourceTrigger = source.getTrigger();
            Port srcPort = source.getPort();
            if (sourceTrigger == null || srcPort == null) continue;
            long txPackets = sourceTrigger.getPacketCount();
            for (FbDestination destination : flowReader.getDestinations()) {
                FbTrigger destinationTrigger = destination.getTrigger();
                if (destinationTrigger == null) continue;
                long rxPackets = destinationTrigger.getPacketCount();
                if (rxPackets == 0L) {
                    tagsToAdd.add("TOTAL_LOSS");
                    continue;
                }
                if (0.9 * (double)txPackets > (double)rxPackets) {
                    tagsToAdd.add("LOSS");
                    continue;
                }
                if (rxPackets <= txPackets) continue;
                tagsToAdd.add("DUPLICATION");
            }
        }
        for (String tagString : tagsToAdd) {
            this.addTag(tagString, reference, control);
        }
    }

    private void addTag(String tagName, TestDataReference testDataReference, TestDataPersistenceController control) {
        TagManager tagManager = new TagManager(control);
        MetaDataPersistenceController.getInstance().addTag(testDataReference, tagName);
        Tag tag = new Tag(tagName);
        tagManager.persistIdEntity((BaseEntity)tag);
    }
}

