/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.postprocessing;

import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.postprocessing.PostProcessor;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;

class LatencyLossSuggestion
extends PostProcessor {
    private static final String LATENCY_WITH_LOSS_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/66/0/use-case-home-gateway-unitary-wan-ethernet-tests";
    private static final Version version = new Version(0, 0, 1);
    private static final double LOSS_ALLOWED = 0.05;

    public LatencyLossSuggestion() {
        super("LatencyLoss", version);
    }

    @Override
    public void process(TestDataReference reference) {
        TestDataPersistenceController control = TestDataPersistenceController.getInstance((Long)reference.getId());
        FlowInstanceManager manager = new FlowInstanceManager(control);
        String scenarioName = reference.getTestName();
        ScenarioManager scmanager = new ScenarioManager(control);
        Scenario scenario = scmanager.find(scenarioName);
        List fbFlows = manager.getAllFrameBlasting(scenario);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            FbSource source = flowInstance.getSource();
            if (source == null || source.getTrigger() == null) continue;
            FbTrigger sourceTrigger = source.getTrigger();
            for (FbDestination destination : destinations) {
                if (destination.getLatency() == null || destination.getTrigger() == null) continue;
                FbTrigger destinationTrigger = destination.getTrigger();
                long srcTraffic = sourceTrigger.getPacketCount();
                long destTraffic = destinationTrigger.getPacketCount();
                if (srcTraffic == 0L || !((double)(srcTraffic - destTraffic) / (double)srcTraffic > 0.05) || destTraffic <= 0L) continue;
                EventManager evt = new EventManager(control);
                String format = "Loss occurred in Flow '%s. The latency measurements are influenced by this loss.\nPotentially, part of the measured latency is the delay due to buffering.\nClick here for more information.";
                String suggestion = String.format(format, flowName);
                FlowInstanceEvent event = new FlowInstanceEvent(new Date(), suggestion, EventSeverity.TEST_SUGGESTION, (FlowInstance)flowInstance);
                event.setKnowledgebaseLink(LATENCY_WITH_LOSS_ARTICLE);
                evt.persistIdEntity((BaseEntity)event);
            }
        }
    }
}

