/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChilderen;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionCumulativeSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionCumulativeSnapshot_;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters_;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot_;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity_;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;

public class CumulativeSnapshotManager
extends BaseEntityManager<TcpSessionCumulativeSnapshot> {
    private HashMap<Long, Long> cumulSnapId = new HashMap();

    public CumulativeSnapshotManager(TestDataPersistenceController pc) {
        super(TcpSessionCumulativeSnapshot.class, pc);
    }

    public TCPSnapshotChilderen cumulativeSnapshot(TcpSessionSnapshot sample) {
        EntityManager em = this.controller.getEntityManager();
        long tcpSessionID = sample.getTcpSession().getId();
        if (this.cumulSnapId.containsKey(sample.getTcpSession().getId())) {
            long snapshotId = this.cumulSnapId.get(tcpSessionID);
            Query updatecumulative = em.createNativeQuery("UPDATE `tcp_session_snapshot` SET                                                   `snapshot_time` =?,                                   `snapshot_duration` =?,                               `connection_state` =?,                                `congestion_window_minimum` =?,                       `congestion_window_current` =?,                       `congestion_window_maximum` =?,                       `receiver_window_minimum` =?,                         `receiver_window_current` =?,                         `receiver_window_maximum` =?,                         `slow_start_threshold_minimum` =?,                    `slow_start_threshold_current` =?,                    `slow_start_threshold_maximum` =?,                    `roundtriptime_minimum` =?,                           `roundtriptime_current` =?,                           `roundtriptime_maximum` =?                            WHERE                                                 `tcp_session_id` = ? AND   id = ?                     ");
            EntityTransaction f = em.getTransaction();
            f.begin();
            int pCtr = 1;
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
            updatecumulative.setParameter(pCtr++, (Object)"010");
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMaximum());
            updatecumulative.setParameter(pCtr++, (Object)tcpSessionID);
            updatecumulative.setParameter(pCtr++, (Object)snapshotId);
            updatecumulative.executeUpdate();
            return new TCPSnapshotChilderen(em, f, snapshotId);
        }
        Query updatecumulative = em.createNativeQuery("UPDATE `tcp_session_snapshot` SET                                                   `snapshot_time` =?,                                   `snapshot_duration` =?,                               `connection_state` =?,                                `congestion_window_minimum` =?,                       `congestion_window_current` =?,                       `congestion_window_maximum` =?,                       `receiver_window_minimum` =?,                         `receiver_window_current` =?,                         `receiver_window_maximum` =?,                         `slow_start_threshold_minimum` =?,                    `slow_start_threshold_current` =?,                    `slow_start_threshold_maximum` =?,                    `roundtriptime_minimum` =?,                           `roundtriptime_current` =?,                           `roundtriptime_maximum` =?                            WHERE                                                  `tcp_session_id` = ? AND                             `id` IN (SELECT  `cumulative`.`snapshot_id`                 FROM    `tcp_session_cumulative_snapshot` as `cumulative`) ");
        Query insertcumulative = em.createNativeQuery("INSERT INTO `tcp_session_snapshot` ( `tcp_session_id` ,                                          `snapshot_time` ,                                           `snapshot_duration` ,                                       `connection_state` ,                                        `congestion_window_minimum` ,                               `congestion_window_current` ,                               `congestion_window_maximum` ,                               `receiver_window_minimum` ,                                 `receiver_window_current` ,                                 `receiver_window_maximum` ,                                 `slow_start_threshold_minimum` ,                            `slow_start_threshold_current` ,                            `slow_start_threshold_maximum` ,                            `roundtriptime_minimum` ,                                   `roundtriptime_current` ,                                   `roundtriptime_maximum` )                                   VALUES( ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?) ");
        EntityTransaction f = em.getTransaction();
        f.begin();
        int pCtr = 1;
        updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
        updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
        updatecumulative.setParameter(pCtr++, (Object)"010");
        updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMinimum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowCurrent());
        updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMaximum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMinimum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowCurrent());
        updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMaximum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMinimum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdCurrent());
        updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMaximum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMinimum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeCurrent());
        updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMaximum());
        updatecumulative.setParameter(pCtr++, (Object)sample.getTcpSession().getId());
        int updated = updatecumulative.executeUpdate();
        if (updated == 0) {
            Random rr = new Random();
            long tmpKey = rr.nextLong();
            tmpKey |= 7L;
            pCtr = 1;
            insertcumulative.setParameter(pCtr++, (Object)sample.getTcpSession().getId());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            insertcumulative.setParameter(pCtr++, (Object)tmpKey);
            insertcumulative.setParameter(pCtr++, (Object)"011");
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMaximum());
            insertcumulative.executeUpdate();
            Query getId = em.createNativeQuery("SELECT `id`                         FROM `tcp_session_snapshot`                       WHERE `tcp_session_id` = ? AND `snapshot_time` = ? AND `snapshot_duration` =? ");
            pCtr = 1;
            getId.setParameter(pCtr++, (Object)sample.getTcpSession().getId());
            getId.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            getId.setParameter(pCtr++, (Object)tmpKey);
            Long id = (Long)getId.getSingleResult();
            sample.getTcpSession().getId();
            Query insertCumulativeRow = em.createNativeQuery("INSERT INTO `tcp_session_cumulative_snapshot`  (`snapshot_id`) VALUES(?)                      ");
            insertCumulativeRow.setParameter(1, (Object)id);
            insertCumulativeRow.executeUpdate();
            Query correctKey = em.createNativeQuery("UPDATE `tcp_session_snapshot` SET `snapshot_duration` =?                                    WHERE  `id` = ?  ");
            correctKey.setParameter(1, (Object)sample.getSnapshotDuration());
            correctKey.setParameter(2, (Object)id);
            correctKey.setParameter(3, (Object)tmpKey);
            correctKey.executeUpdate();
            this.cumulSnapId.put(sample.getTcpSession().getId(), id);
            return new TCPSnapshotChilderen(em, f, id);
        }
        if (updated > 1) {
            Logger.getGlobal().severe("TODO should rollback");
        }
        Query getId = em.createNativeQuery("SELECT A.`id`                                 FROM `tcp_session_snapshot` AS A, tcp_session_cumulative_snapshot AS B   WHERE A.id = B.snapshot_id AND`tcp_session_id` = ?");
        getId.setParameter(1, (Object)sample.getTcpSession().getId());
        Long id = (Long)getId.getSingleResult();
        return new TCPSnapshotChilderen(em, f, id);
    }

    public TcpSessionSnapshot find(TcpSession session) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(TcpSessionCumulativeSnapshot.class);
        Root snapshots = query.from(TcpSessionCumulativeSnapshot.class);
        query.where((Expression)qb.equal((Expression)snapshots.join(TcpSessionCumulativeSnapshot_.snapshot).get(TcpSessionSnapshot_.tcpSession).get(BaseEntity_.id), (Object)session.getId()));
        TcpSessionCumulativeSnapshot res = (TcpSessionCumulativeSnapshot)this.controller.getEntity(query);
        if (res != null) {
            return res.getSnapshot();
        }
        return null;
    }

    public TcpSessionSnapshotSynReceived findSynRx(TcpSession session) throws TestDataPersistenceError {
        TcpSessionSnapshot cumulative = this.find(session);
        if (session == null) {
            return null;
        }
        String strQuery = "SELECT d FROM TcpSessionSnapshotSynReceived d WHERE d.snapshot = :snap";
        TypedQuery query = this.controller.getEntityManager().createQuery(strQuery, TcpSessionSnapshotSynReceived.class);
        query.setParameter("snap", (Object)cumulative);
        try {
            return (TcpSessionSnapshotSynReceived)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public TcpSessionSnapshotSynSent findSynSent(TcpSession session) throws TestDataPersistenceError {
        TcpSessionSnapshot cumulative = this.find(session);
        if (session == null) {
            return null;
        }
        String strQuery = "SELECT d FROM TcpSessionSnapshotSynSent d WHERE d.snapshot = :snap";
        TypedQuery query = this.controller.getEntityManager().createQuery(strQuery, TcpSessionSnapshotSynSent.class);
        query.setParameter("snap", (Object)cumulative);
        try {
            return (TcpSessionSnapshotSynSent)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public TcpSessionSnapshotRetransmissionCounters findRetransmissionCount(TcpSession session) throws TestDataPersistenceError {
        TcpSessionSnapshot cumulative = this.find(session);
        if (session == null) {
            return null;
        }
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(TcpSessionSnapshotRetransmissionCounters.class);
        Root retransmissions = query.from(TcpSessionSnapshotRetransmissionCounters.class);
        Predicate joinSnapshotId = qb.equal((Expression)retransmissions.get(TcpSessionSnapshotRetransmissionCounters_.snapshot), (Object)cumulative);
        query.where((Expression)joinSnapshotId);
        TcpSessionSnapshotRetransmissionCounters result = (TcpSessionSnapshotRetransmissionCounters)this.controller.getEntity(query);
        return result;
    }
}

