/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChild;
import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChilderen;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.logging.Logger;

public class IntervalSnapshotManager {
    private HashMap<Long, Long> lastSnapShot = new HashMap();
    private final TestDataPersistenceController controller;

    public IntervalSnapshotManager(TestDataPersistenceController pc) {
        this.controller = pc;
    }

    public TCPSnapshotChild intervalSnapshot(TcpSessionSnapshot sample) {
        long tcpSessionId = sample.getTcpSession().getId();
        long timeStamp = sample.getSnapshotTime();
        boolean doUpdate = false;
        if (this.lastSnapShot.containsKey(tcpSessionId)) {
            long lastStoredTimeStamp = this.lastSnapShot.get(tcpSessionId);
            if (timeStamp < lastStoredTimeStamp) {
                return new EmptyInsert();
            }
            if (timeStamp == lastStoredTimeStamp) {
                doUpdate = true;
            }
        }
        EntityManager em = this.controller.getEntityManager();
        EntityTransaction f = em.getTransaction();
        f.begin();
        int pCtr = 1;
        int updated = 0;
        if (doUpdate) {
            Query updatecumulative = em.createNativeQuery("UPDATE `tcp_session_snapshot` SET                                                   `snapshot_duration` =?,                               `connection_state` =?,                                `congestion_window_minimum` =?,                       `congestion_window_current` =?,                       `congestion_window_maximum` =?,                       `receiver_window_minimum` =?,                         `receiver_window_current` =?,                         `receiver_window_maximum` =?,                         `slow_start_threshold_minimum` =?,                    `slow_start_threshold_current` =?,                    `slow_start_threshold_maximum` =?,                    `roundtriptime_minimum` =?,                           `roundtriptime_current` =?,                           `roundtriptime_maximum` =?                            WHERE                                                 `tcp_session_id` = ? AND  `snapshot_time` =?  AND     `id` NOT IN (SELECT  `cumulative`.`snapshot_id`              FROM    `tcp_session_cumulative_snapshot` as `cumulative`) ");
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
            updatecumulative.setParameter(pCtr++, (Object)"001");
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMinimum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeCurrent());
            updatecumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMaximum());
            updatecumulative.setParameter(pCtr++, (Object)sample.getTcpSession().getId());
            updatecumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            updated = updatecumulative.executeUpdate();
        }
        if (updated == 0) {
            Query insertcumulative = em.createNativeQuery("INSERT INTO `tcp_session_snapshot` ( `tcp_session_id` ,                                          `snapshot_time` ,                                           `snapshot_duration` ,                                       `connection_state` ,                                        `congestion_window_minimum` ,                               `congestion_window_current` ,                               `congestion_window_maximum` ,                               `receiver_window_minimum` ,                                 `receiver_window_current` ,                                 `receiver_window_maximum` ,                                 `slow_start_threshold_minimum` ,                            `slow_start_threshold_current` ,                            `slow_start_threshold_maximum` ,                            `roundtriptime_minimum` ,                                   `roundtriptime_current` ,                                   `roundtriptime_maximum` )                                   VALUES( ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?,  ?) ");
            pCtr = 1;
            insertcumulative.setParameter(pCtr++, (Object)sample.getTcpSession().getId());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSnapshotTime());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSnapshotDuration());
            insertcumulative.setParameter(pCtr++, (Object)"000");
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getCongestionWindowMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getReceiverWindowMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getSlowStartThresholdMaximum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMinimum());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeCurrent());
            insertcumulative.setParameter(pCtr++, (Object)sample.getRoundTripTimeMaximum());
            insertcumulative.executeUpdate();
        } else if (updated > 1) {
            Logger.getGlobal().severe("TODO should rollback");
        }
        if (this.lastSnapShot.containsKey(tcpSessionId)) {
            this.lastSnapShot.put(tcpSessionId, Math.max(this.lastSnapShot.get(tcpSessionId), timeStamp));
        } else {
            this.lastSnapShot.put(tcpSessionId, timeStamp);
        }
        return new TCPSnapshotChilderen(em, f, this.findIntervalSnapshot(sample.getSnapshotTime(), sample.getTcpSession().getId()));
    }

    public long findIntervalSnapshot(long snapshotTimestamp, long tcpSessionId) {
        EntityManager em = this.controller.getEntityManager();
        Query getId = em.createNativeQuery("SELECT a.`id` FROM `tcp_session_snapshot` as A LEFT OUTER JOIN tcp_session_cumulative_snapshot as B ON a.id = b.snapshot_id WHERE a.`tcp_session_id` = ? AND a.`snapshot_time` = ? AND b.id is NULL");
        int pCtr = 1;
        getId.setParameter(pCtr++, (Object)tcpSessionId);
        getId.setParameter(pCtr++, (Object)snapshotTimestamp);
        try {
            Long id = (Long)getId.getSingleResult();
            return id;
        }
        catch (Exception e) {
            System.err.println("problem fetching results:");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return -1L;
        }
    }

    private static final class EmptyInsert
    implements TCPSnapshotChild {
        private EmptyInsert() {
        }

        @Override
        public void add(TcpSessionSnapshotTxCounters counters) {
        }

        @Override
        public void add(TcpSessionSnapshotRxCounters rxCounters) {
        }

        @Override
        public void add(TcpSessionSnapshotRetransmissionCounters retransmission) {
        }

        @Override
        public void add(TcpSessionSnapshotSynSent synTxData) {
        }

        @Override
        public void add(TcpSessionSnapshotSynReceived synData) {
        }

        @Override
        public void add(TcpSessionSnapshotFinSent finTxData) {
        }

        @Override
        public void add(TcpSessionSnapshotFinReceived finRxData) {
        }

        @Override
        public void done() {
        }
    }
}

