/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping_;
import com.excentis.products.byteblower.results.testdata.data.enums.NatPortMappingProtocol;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;

public class NatPortMappingManager
extends BaseEntityManager<NatPortMapping> {
    public NatPortMappingManager(TestDataPersistenceController pc) {
        super(NatPortMapping.class, pc);
    }

    public NatPortMapping createOrUpdate(NatAddressMapping addressMapping, NatPortMappingProtocol protocol, Integer privatePort, Integer publicPort, String method) throws TestDataPersistenceError {
        NatPortMapping dbEntity = this.find(addressMapping, protocol, privatePort);
        if (dbEntity == null) {
            dbEntity = new NatPortMapping(addressMapping, protocol, privatePort, publicPort, method);
            this.persistIdEntity(dbEntity);
        } else {
            dbEntity.setPublicPort(publicPort);
            this.persistIdEntity(dbEntity);
        }
        return dbEntity;
    }

    public NatPortMapping find(NatAddressMapping addressMapping, NatPortMappingProtocol protocol, Integer privatePort) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(NatPortMapping.class);
        Root portMappings = query.from(NatPortMapping.class);
        query.where((Expression)qb.and(new Predicate[]{qb.equal((Expression)portMappings.get(NatPortMapping_.addressMapping), (Object)addressMapping), qb.equal((Expression)portMappings.get(NatPortMapping_.protocol), (Object)protocol), qb.equal((Expression)portMappings.get(NatPortMapping_.privatePort), (Object)privatePort)}));
        return (NatPortMapping)this.controller.getEntity(query);
    }

    public List<NatPortMapping> findAll(NatAddressMapping addressMapping) throws TestDataPersistenceError {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(NatPortMapping.class);
        Root portMappings = query.from(NatPortMapping.class);
        query.where((Expression)qb.equal((Expression)portMappings.get(NatPortMapping_.addressMapping), (Object)addressMapping));
        return this.controller.getEntities(query);
    }
}

