/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceError;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address_;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.Server_;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;

public class ServerManager
extends BaseEntityManager<Server> {
    public ServerManager(TestDataPersistenceController controller) {
        super(Server.class, controller);
    }

    public Server findOnIp(String ipAddress) throws TestDataPersistenceConversionError, TestDataPersistenceError {
        byte[] ipBinary = Ipv4AddressUtility.convertToBinary(ipAddress);
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Server.class);
        Join servers = query.from(Server.class).join(Server_.ipv4Address);
        query.where((Expression)qb.equal((Expression)servers.get(Ipv4Address_.address), (Object)ipBinary));
        return (Server)this.controller.getEntity(query);
    }

    public Server findOnUuid(String uuid) {
        CriteriaBuilder qb = this.controller.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Server.class);
        Root servers = query.from(Server.class);
        query.where((Expression)qb.equal((Expression)servers.get(Server_.uuid), (Object)uuid));
        return (Server)this.controller.getEntity(query);
    }
}

