/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data;

import com.excentis.products.byteblower.results.testdata.data.TCPSnapshotChild;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotFinSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import jakarta.persistence.Column;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPSnapshotChilderen
implements TCPSnapshotChild {
    private static final Logger LOGGER = Logger.getGlobal();
    private final EntityManager em;
    private final EntityTransaction transact;
    private final long snapShotId;

    TCPSnapshotChilderen(EntityManager em, EntityTransaction trans, long snapshotId) {
        this.transact = trans;
        this.em = em;
        this.snapShotId = snapshotId;
    }

    private ArrayList<MappedColumn> columns(Class<?> j) {
        Method[] methods = j.getDeclaredMethods();
        ArrayList<MappedColumn> result = new ArrayList<MappedColumn>();
        Field[] fieldArray = j.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Annotation[] annotationArray = f.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation an = annotationArray[n4];
                if (an instanceof Column) {
                    Column column = (Column)an;
                    String name = column.name();
                    Method m = this.findMatchingGetter(f, methods);
                    result.add(new MappedColumn(m, name));
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private Method findMatchingGetter(Field f, Method[] sourceMethods) {
        String essentialName = f.getName().toLowerCase();
        Method[] methodArray = sourceMethods;
        int n = sourceMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getReturnType() == f.getType() && m.getParameterTypes().length == 0 && m.getName().toLowerCase().contains(essentialName)) {
                return m;
            }
            ++n2;
        }
        String errorMsg = String.format("Found no getter for field %s\n", f.getName());
        Logger.getGlobal().log(Level.SEVERE, errorMsg);
        return null;
    }

    private Query fillUpdateQuery(Query q, ArrayList<MappedColumn> columns, Object o) {
        int sqlParamIdx = 1;
        for (MappedColumn c : columns) {
            try {
                Object value = c.method.invoke(o, new Object[0]);
                q.setParameter(sqlParamIdx++, value);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "Not able to access field", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Method not derived from instance", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Invalid arguments to getter", e);
            }
        }
        q.setParameter(sqlParamIdx, (Object)this.snapShotId);
        return q;
    }

    private Query createUpdateQuery(String table, Object o) {
        Query q;
        ArrayList<MappedColumn> columns;
        CachedQuery cache = CachedQuery.getUpdate(this.em, o.getClass());
        if (cache == null) {
            columns = this.columns(o.getClass());
            String update = String.format("UPDATE `%s` SET (", table);
            boolean first = true;
            for (MappedColumn c : columns) {
                if (!first) {
                    update = String.valueOf(update) + ", ";
                }
                update = String.valueOf(update) + "`" + c.column + "`";
                first = false;
            }
            update = String.valueOf(update) + ") = ";
            update = String.valueOf(update) + "(SELECT ";
            first = true;
            int ctr = 0;
            while (ctr < columns.size()) {
                if (!first) {
                    update = String.valueOf(update) + ", ";
                }
                update = String.valueOf(update) + "?";
                first = false;
                ++ctr;
            }
            update = String.valueOf(update) + ") WHERE `snapshot_id` = ?";
            q = this.em.createNativeQuery(update);
            CachedQuery.addUpdate(this.em, o.getClass(), q, columns);
        } else {
            q = cache.query;
            columns = cache.mappedColumns;
        }
        return this.fillUpdateQuery(q, columns, o);
    }

    private Query fillInsertQuery(Query q, ArrayList<MappedColumn> columns, Object o) {
        int sqlParamIdx = 1;
        q.setParameter(sqlParamIdx++, (Object)this.snapShotId);
        for (MappedColumn c : columns) {
            try {
                Object value = c.method.invoke(o, new Object[0]);
                q.setParameter(sqlParamIdx++, value);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "Not able to access field", e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Method not derived from instance", e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Invalid arguments to getter", e);
            }
        }
        return q;
    }

    private Query createInsertQuery(String table, Object o) {
        Query q;
        ArrayList<MappedColumn> columns;
        CachedQuery cache = CachedQuery.getInsert(this.em, o.getClass());
        if (cache == null) {
            columns = this.columns(o.getClass());
            String insert = String.format("INSERT INTO `%s`(`snapshot_id`", table);
            for (MappedColumn c : columns) {
                insert = String.valueOf(insert) + ", `" + c.column + "`";
            }
            insert = String.valueOf(insert) + ") DIRECT SELECT ? ";
            int ctr = 0;
            while (ctr < columns.size()) {
                insert = String.valueOf(insert) + ", ?";
                ++ctr;
            }
            q = this.em.createNativeQuery(insert);
            CachedQuery.addInsert(this.em, o.getClass(), q, columns);
        } else {
            q = cache.query;
            columns = cache.mappedColumns;
        }
        return this.fillInsertQuery(q, columns, o);
    }

    private void add(String tableName, Object value) {
        Query insert = this.createInsertQuery(tableName, value);
        Query update = this.createUpdateQuery(tableName, value);
        if (update.executeUpdate() == 0) {
            insert.executeUpdate();
        }
    }

    @Override
    public void done() {
        this.transact.commit();
    }

    @Override
    public void add(TcpSessionSnapshotRetransmissionCounters retransmission) {
        this.add("tcp_session_snapshot_retransmission_counters", retransmission);
    }

    @Override
    public void add(TcpSessionSnapshotRxCounters rxCounters) {
        this.add("tcp_session_snapshot_rx_counters", rxCounters);
    }

    @Override
    public void add(TcpSessionSnapshotTxCounters txCounters) {
        this.add("tcp_session_snapshot_tx_counters", txCounters);
    }

    @Override
    public void add(TcpSessionSnapshotSynReceived synData) {
        this.add("tcp_session_snapshot_syn_received", synData);
    }

    @Override
    public void add(TcpSessionSnapshotFinSent finTxData) {
        this.add("tcp_session_snapshot_fin_sent", finTxData);
    }

    @Override
    public void add(TcpSessionSnapshotFinReceived finRxData) {
        this.add("tcp_session_snapshot_fin_received", finRxData);
    }

    @Override
    public void add(TcpSessionSnapshotSynSent synTxData) {
        this.add("tcp_session_snapshot_syn_sent", synTxData);
    }

    private static final class CachedQuery {
        private static ArrayList<WeakReference<CachedQuery>> queryCache = new ArrayList();
        private static final int CLEANUP_RATE = 16;
        private final EntityManager em;
        private final Class target;
        private final Query query;
        private final Type type;
        private final ArrayList<MappedColumn> mappedColumns;

        public CachedQuery(EntityManager em, Class target, Type type) {
            this.em = em;
            this.target = target;
            this.type = type;
            this.query = null;
            this.mappedColumns = null;
        }

        public CachedQuery(EntityManager em, Class target, Query query, Type type, ArrayList<MappedColumn> mappedColumns) {
            this.em = em;
            this.target = target;
            query.setHint("eclipselink.prepare", (Object)true);
            this.query = query;
            this.type = type;
            this.mappedColumns = mappedColumns;
        }

        private static void cleanCache() {
            int goodCnt = 0;
            for (WeakReference<CachedQuery> q : queryCache) {
                if (q.get() == null) continue;
                ++goodCnt;
            }
            if (goodCnt == queryCache.size()) {
                return;
            }
            if (goodCnt == 0) {
                queryCache.clear();
                return;
            }
            ArrayList<WeakReference<CachedQuery>> tmp = new ArrayList<WeakReference<CachedQuery>>(goodCnt);
            for (WeakReference<CachedQuery> q : queryCache) {
                if (q.get() == null) continue;
                tmp.add(q);
            }
            queryCache = tmp;
        }

        private static boolean shouldClean() {
            return queryCache.size() % 16 == 0;
        }

        public static void addInsert(EntityManager em, Class target, Query query, ArrayList<MappedColumn> columns) {
            CachedQuery cache = new CachedQuery(em, target, query, Type.INSERT, columns);
            if (CachedQuery.shouldClean()) {
                CachedQuery.cleanCache();
            }
            queryCache.add(new WeakReference<CachedQuery>(cache));
        }

        public static void addUpdate(EntityManager em, Class target, Query query, ArrayList<MappedColumn> columns) {
            CachedQuery cache = new CachedQuery(em, target, query, Type.UPDATE, columns);
            if (CachedQuery.shouldClean()) {
                CachedQuery.cleanCache();
            }
            queryCache.add(new WeakReference<CachedQuery>(cache));
        }

        public static CachedQuery getUpdate(EntityManager em, Class target) {
            CachedQuery cache = new CachedQuery(em, target, Type.UPDATE);
            for (WeakReference<CachedQuery> q : queryCache) {
                CachedQuery stored = (CachedQuery)q.get();
                if (stored == null || !stored.equals(cache)) continue;
                return stored;
            }
            return null;
        }

        public static CachedQuery getInsert(EntityManager em, Class target) {
            CachedQuery cache = new CachedQuery(em, target, Type.INSERT);
            for (WeakReference<CachedQuery> q : queryCache) {
                CachedQuery stored = (CachedQuery)q.get();
                if (stored == null || !stored.equals(cache)) continue;
                return stored;
            }
            return null;
        }

        public int hashCode() {
            return this.target.hashCode() + this.type.ordinal() + this.em.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof CachedQuery) {
                CachedQuery othQuery = (CachedQuery)o;
                return this.em == othQuery.em && this.target == othQuery.target && this.type == othQuery.type;
            }
            return false;
        }

        private static enum Type {
            INSERT,
            UPDATE;

        }
    }

    private static final class MappedColumn {
        public final Method method;
        public final String column;

        public MappedColumn(Method method, String column) {
            this.method = method;
            this.column = column;
        }
    }
}

