/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastConfiguration;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Set;

@Entity
@DiscriminatorValue(value="MULTICAST")
@Table(name="fb_destination_config_multicast")
public class FbDestinationConfigMulticast
extends FbDestinationConfig {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="multicast_configuration_id", nullable=false)
    private MulticastConfiguration multicastConfiguration;
    @OneToMany
    @JoinTable(name="fb_multicast_member_destination", joinColumns={@JoinColumn(name="fb_destination_config_multicast_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="fb_destination_id", referencedColumnName="id", unique=true)})
    private Set<FbDestination> destinations;

    public FbDestinationConfigMulticast(FbFlowInstance flowInstance, MulticastConfiguration multicastConfiguration) {
        super(flowInstance);
        if (multicastConfiguration == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'multicastConfiguration' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.multicastConfiguration = multicastConfiguration;
        this.destinations = new HashSet<FbDestination>();
    }

    FbDestinationConfigMulticast() {
    }

    public MulticastConfiguration getMulticastConfiguration() {
        return this.multicastConfiguration;
    }

    public Set<FbDestination> getDestinations() {
        return this.destinations;
    }

    public void addDestination(FbDestination destination) {
        if (!this.destinations.contains(destination)) {
            this.destinations.add(destination);
        }
    }
}

