/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.interfaces.IFbResult;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Entity
@Table(name="fb_latency")
public class FbLatency
extends BaseEntity
implements IFbResult<FbLatencySnapshot> {
    private static final long serialVersionUID = 1L;
    @Column(name="packet_count_valid", nullable=false)
    private Long packetCountValid = 0L;
    @Column(name="packet_count_invalid", nullable=false)
    private Long packetCountInvalid = 0L;
    @Column(name="latency_minimum")
    private Long latencyMinimum = null;
    @Column(name="latency_average")
    private Long latencyAverage = null;
    @Column(name="latency_maximum")
    private Long latencyMaximum = null;
    @Column(name="jitter")
    private Long jitter = null;
    @Column(name="latency_precision")
    private Long latencyPrecision = null;
    @Column(name="snapshot_resolution")
    private Long snapshotResolution;
    @OneToMany(mappedBy="latency")
    private List<FbLatencySnapshot> snapshots = new ArrayList<FbLatencySnapshot>();
    @OneToOne(mappedBy="latency")
    private FbLatencyDistribution distribution = null;
    @Transient
    private FbLatencySnapshot latestSnapshot;

    public Long getPacketCountValid() {
        return this.packetCountValid;
    }

    public void setPacketCountValid(Long packetCountValid) {
        this.packetCountValid = packetCountValid;
    }

    public Long getPacketCountInvalid() {
        return this.packetCountInvalid;
    }

    public void setPacketCountInvalid(Long packetCountInvalid) {
        this.packetCountInvalid = packetCountInvalid;
    }

    public Long getLatencyMinimum() {
        return this.latencyMinimum;
    }

    public void setLatencyMinimum(Long latencyMinimum) {
        this.latencyMinimum = latencyMinimum;
    }

    public Long getLatencyAverage() {
        return this.latencyAverage;
    }

    public void setLatencyAverage(Long latencyAverage) {
        this.latencyAverage = latencyAverage;
    }

    public Long getLatencyMaximum() {
        return this.latencyMaximum;
    }

    public void setLatencyMaximum(Long latencyMaximum) {
        this.latencyMaximum = latencyMaximum;
    }

    public Long getJitter() {
        return this.jitter;
    }

    public void setJitter(Long jitter) {
        this.jitter = jitter;
    }

    public Long getLatencyPrecision() {
        return this.latencyPrecision;
    }

    public void setLatencyPrecision(Long latencyPrecision) {
        if (this.latencyPrecision != null) {
            throw new IllegalStateException("Cannot modify entity property 'latencyPrecision' once it has been set");
        }
        if (latencyPrecision == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'latencyPrecision' of type " + this.getClass().getSimpleName());
        }
        this.latencyPrecision = latencyPrecision;
    }

    public Long getSnapshotResolution() {
        return this.snapshotResolution;
    }

    public void setSnapshotResolution(Long snapshotResolution) {
        if (this.snapshotResolution != null) {
            throw new IllegalStateException("Cannot modify entity property 'snapshotResolution' once it has been set");
        }
        if (snapshotResolution == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'snapshotResolution' of type " + this.getClass().getSimpleName());
        }
        this.snapshotResolution = snapshotResolution;
    }

    @Override
    public List<FbLatencySnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    void addSnapshot(FbLatencySnapshot snapshot) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding entity property 'snapshot' of type " + this.getClass().getSimpleName());
        }
        this.snapshots.add(snapshot);
    }

    public FbLatencyDistribution getDistribution() {
        return this.distribution;
    }

    void setDistribution(FbLatencyDistribution distribution) {
        if (distribution == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'distribution' of type " + this.getClass().getSimpleName());
        }
        this.distribution = distribution;
    }

    public void setLatestSnapshot(FbLatencySnapshot snapshot) {
        this.latestSnapshot = snapshot;
    }

    @Override
    public FbLatencySnapshot getLatestSnapshot() {
        return this.latestSnapshot;
    }
}

