/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSizeDistributionEntry;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Entity
@Table(name="fb_trigger_sizedistribution")
public class FbTriggerSizeDistribution
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToOne
    @JoinColumn(name="trigger_id", nullable=false, unique=true)
    private FbTrigger trigger;
    @Column(name="min_framesize_checked", nullable=false)
    private Integer minFramesizeChecked;
    @Column(name="max_framesize_checked", nullable=false)
    private Integer maxFramesizeChecked;
    @OneToMany(mappedBy="distribution", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<FbTriggerSizeDistributionEntry> distributionEntries;

    public FbTriggerSizeDistribution(FbTrigger trigger, Integer minFramesizeChecked, Integer maxFramesizeChecked) {
        if (trigger == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'trigger' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (minFramesizeChecked == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'minFramesizeChecked' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (maxFramesizeChecked == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'maxFramesizeChecked' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.trigger = trigger;
        this.minFramesizeChecked = minFramesizeChecked;
        this.maxFramesizeChecked = maxFramesizeChecked;
        this.distributionEntries = new HashSet<FbTriggerSizeDistributionEntry>();
    }

    FbTriggerSizeDistribution() {
    }

    public FbTrigger getTrigger() {
        return this.trigger;
    }

    public Integer getMinFramesizeChecked() {
        return this.minFramesizeChecked;
    }

    public Integer getMaxFramesizeChecked() {
        return this.maxFramesizeChecked;
    }

    public Map<Integer, Long> getEntries() {
        HashMap<Integer, Long> distributionMap = new HashMap<Integer, Long>();
        for (FbTriggerSizeDistributionEntry distributionEntry : this.distributionEntries) {
            distributionMap.put(distributionEntry.getSize(), distributionEntry.getPacketCount());
        }
        return Collections.unmodifiableMap(distributionMap);
    }

    public void addEntry(Integer size, Long packetCount) {
        this.distributionEntries.add(new FbTriggerSizeDistributionEntry(this, size, packetCount));
    }
}

