/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4ConfigurationDhcpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4ConfigurationStatic;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.enums.Ipv4Method;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;

@Entity
@DiscriminatorValue(value="IPV4")
@Table(name="layer3_ipv4")
public class Layer3Ipv4
extends Layer3 {
    private static final long serialVersionUID = 1L;
    @Enumerated(value=EnumType.STRING)
    @Column(name="method", length=40, nullable=false)
    private Ipv4Method method;
    @ManyToOne
    @JoinColumn(name="dhcp_configuration_id")
    private Layer3Ipv4ConfigurationDhcpv4 dhcpConfiguration;
    @ManyToOne
    @JoinColumn(name="static_configuration_id")
    private Layer3Ipv4ConfigurationStatic staticConfiguration;
    @ManyToOne
    @JoinColumn(name="nat_configuration_id")
    private Ipv4NatConfiguration natConfiguration;
    @OneToOne(mappedBy="configuration")
    private Layer3Ipv4Session session;

    public Layer3Ipv4(Port port, Layer3Ipv4ConfigurationDhcpv4 dhcpConfiguration, Ipv4NatConfiguration natConfiguration) {
        this(port, natConfiguration);
        if (dhcpConfiguration == null) {
            throw new IllegalArgumentException("Cannot provide null value for entity property 'dhcpConfiguration' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.method = Ipv4Method.DHCP;
        this.dhcpConfiguration = dhcpConfiguration;
        this.staticConfiguration = null;
    }

    public Layer3Ipv4(Port port, Layer3Ipv4ConfigurationStatic staticConfiguration, Ipv4NatConfiguration natConfiguration) {
        this(port, natConfiguration);
        if (staticConfiguration == null) {
            throw new IllegalArgumentException("Cannot provide null value for entity property 'staticConfiguration' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.method = Ipv4Method.FIXED;
        this.staticConfiguration = staticConfiguration;
        this.dhcpConfiguration = null;
    }

    private Layer3Ipv4(Port port, Ipv4NatConfiguration natConfiguration) {
        super(port);
        this.natConfiguration = natConfiguration;
    }

    Layer3Ipv4() {
    }

    public Ipv4Method getMethod() {
        return this.method;
    }

    public Layer3Ipv4ConfigurationDhcpv4 getDhcpConfiguration() {
        return this.dhcpConfiguration;
    }

    public Layer3Ipv4ConfigurationStatic getFixedConfiguration() {
        return this.staticConfiguration;
    }

    public Ipv4NatConfiguration getNatConfiguration() {
        return this.natConfiguration;
    }

    public Layer3Ipv4Session getSession() {
        return this.session;
    }

    void setSession(Layer3Ipv4Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'session' of type " + this.getClass().getSimpleName());
        }
        this.session = session;
    }
}

