/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationStaticAddressRef;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6ConfigurationStaticGatewayRef;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.utils.Pair;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="layer3_ipv6_configuration_static")
public class Layer3Ipv6ConfigurationStatic
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Layer3Ipv6ConfigurationStaticAddressRef> addressRefs;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Layer3Ipv6ConfigurationStaticGatewayRef> gatewayRefs;
    @Column(name="placeholder", nullable=false)
    private Boolean placeholder;

    public Layer3Ipv6ConfigurationStatic(Set<Pair<Ipv6Address, Integer>> addressesWithPrefix, Set<Pair<Ipv6Address, Integer>> gatewaysWithPrefix) {
        Integer prefixValue;
        Ipv6Address addressValue;
        if (addressesWithPrefix == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'addressesWithPrefix' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (gatewaysWithPrefix == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'gatewaysWithPrefix' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.addressRefs = new HashSet<Layer3Ipv6ConfigurationStaticAddressRef>();
        for (Pair<Ipv6Address, Integer> addressWithPrefix : addressesWithPrefix) {
            addressValue = addressWithPrefix.getFirst();
            prefixValue = addressWithPrefix.getSecond();
            this.addressRefs.add(new Layer3Ipv6ConfigurationStaticAddressRef(this, addressValue, prefixValue));
        }
        this.gatewayRefs = new HashSet<Layer3Ipv6ConfigurationStaticGatewayRef>();
        for (Pair<Ipv6Address, Integer> gatewayWithPrefix : gatewaysWithPrefix) {
            addressValue = gatewayWithPrefix.getFirst();
            prefixValue = gatewayWithPrefix.getSecond();
            this.gatewayRefs.add(new Layer3Ipv6ConfigurationStaticGatewayRef(this, addressValue, prefixValue));
        }
        this.placeholder = true;
    }

    Layer3Ipv6ConfigurationStatic() {
    }

    public Set<Pair<Ipv6Address, Integer>> getAddresses() {
        HashSet<Pair<Ipv6Address, Integer>> returnSet = new HashSet<Pair<Ipv6Address, Integer>>();
        for (Layer3Ipv6ConfigurationStaticAddressRef addressRef : this.addressRefs) {
            returnSet.add(new Pair<Ipv6Address, Integer>(addressRef.getAddress(), addressRef.getPrefixLength()));
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public Set<Pair<Ipv6Address, Integer>> getGatewayAddresses() {
        HashSet<Pair<Ipv6Address, Integer>> returnSet = new HashSet<Pair<Ipv6Address, Integer>>();
        for (Layer3Ipv6ConfigurationStaticGatewayRef gatewayRef : this.gatewayRefs) {
            returnSet.add(new Pair<Ipv6Address, Integer>(gatewayRef.getAddress(), gatewayRef.getPrefixLength()));
        }
        return Collections.unmodifiableSet(returnSet);
    }
}

