/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="layer3_ipv6_session_prefix")
public class Layer3Ipv6SessionPrefix
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="session_id", nullable=false)
    private Layer3Ipv6Session session;
    @ManyToOne
    @JoinColumn(name="network_address_id", nullable=false)
    private Ipv6Address networkAddress;
    @Column(name="prefix_length", nullable=false)
    private Integer prefixLength;
    @OneToMany(mappedBy="prefix")
    private Set<Layer3Ipv6SessionAddress> addresses;

    public Layer3Ipv6SessionPrefix(Layer3Ipv6Session session, Ipv6Address networkAddress, Integer prefixLength) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'session' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (networkAddress == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'networkAddress' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (prefixLength == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'prefixLength' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.session = session;
        this.session.addPrefix(this);
        this.networkAddress = networkAddress;
        this.prefixLength = prefixLength;
        this.addresses = new HashSet<Layer3Ipv6SessionAddress>();
    }

    Layer3Ipv6SessionPrefix() {
    }

    public Layer3Ipv6Session getSession() {
        return this.session;
    }

    public Ipv6Address getNetworkAddress() {
        return this.networkAddress;
    }

    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    public Set<Layer3Ipv6SessionAddress> getAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    void addAddress(Layer3Ipv6SessionAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot provide null value when adding address to entity property 'addresses' of type " + this.getClass().getSimpleName());
        }
        if (!this.addresses.contains(address)) {
            this.addresses.add(address);
        }
    }
}

