/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.Interface;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer2;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.PortStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="port")
public class Port
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    public static final int NO_RSSI = -127;
    public static final String NO_BSSID = "";
    public static final String NO_SSID = "";
    public static final long INITIAL_MOMENT = 0L;
    @Column(name="name", length=21844, unique=true, nullable=false)
    private String name;
    @ManyToOne
    @JoinColumn(name="interface_id", nullable=false)
    private Interface serverInterface;
    @OneToOne(mappedBy="port")
    private Layer2 layer2;
    @OneToOne(mappedBy="port")
    private Layer3 layer3;
    @Column(name="mtu", nullable=false)
    private Integer mtu;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=40, nullable=false)
    private PortStatus status;
    @Column(name="docked", length=1000, unique=false, nullable=false)
    private String docked;
    @Transient
    public long rssi = -127L;
    @Transient
    public String ssid = "";
    @Transient
    public String bssid = "";
    @Transient
    public long lastSeen = 0L;

    public Port(String name, Interface serverInterface, Integer mtu, String docked) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (serverInterface == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'serverInterface' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (mtu == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'mtu' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.name = name;
        this.serverInterface = serverInterface;
        this.mtu = mtu;
        this.layer2 = null;
        this.layer3 = null;
        this.status = PortStatus.CREATED;
        this.docked = docked;
    }

    Port() {
    }

    public String getName() {
        return this.name;
    }

    public Interface getInterface() {
        return this.serverInterface;
    }

    public Layer2 getLayer2() {
        return this.layer2;
    }

    void setLayer2(Layer2 layer2) {
        if (this.layer2 != null) {
            throw new IllegalStateException("Cannot modify entity property 'layer2' once it has been set");
        }
        if (layer2 == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'layer2' of type " + this.getClass().getSimpleName());
        }
        this.layer2 = layer2;
    }

    public Layer3 getLayer3() {
        return this.layer3;
    }

    void setLayer3(Layer3 layer3) {
        if (this.layer3 != null) {
            throw new IllegalStateException("Cannot modify entity property 'layer3' once it has been set");
        }
        if (layer3 == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'layer3' of type " + this.getClass().getSimpleName());
        }
        this.layer3 = layer3;
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public PortStatus getStatus() {
        return this.status;
    }

    public boolean isDockedMobile() {
        Server server = this.serverInterface.getServer();
        return server != null && ServerType.MEETING_POINT.equals((Object)server.getType());
    }

    public void setStatus(PortStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'status' of type " + this.getClass().getSimpleName());
        }
        this.status = status;
    }

    public String getDocked() {
        return this.docked;
    }

    public String toString() {
        return "Port entity: " + this.name;
    }

    public boolean hasWiFiStats() {
        return this.rssi > -127L;
    }

    public void resetWiFi() {
        this.rssi = -127L;
        this.ssid = "";
        this.bssid = "";
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj instanceof Port) {
            String otherName = ((Port)otherObj).name;
            return this.name.equals(otherName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

