/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.TestStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.TestType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;

@Entity
@Table(name="test")
public class Test
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="project_name", length=21844, nullable=false)
    private String projectName;
    @Column(name="project_author", length=21844, nullable=false)
    private String projectAuthor;
    @Column(name="project_version", length=40, nullable=false)
    private String projectVersion;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", length=40, nullable=false)
    private TestType type;
    @Column(name="name", length=21844, nullable=false)
    private String name;
    @Column(name="run_title", length=21844, nullable=false)
    private String runTitle;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=40, nullable=false)
    private TestStatus status;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="init_start_time")
    private Date initStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="init_end_time")
    private Date initEndTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="run_start_time")
    private Date runStartTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="run_end_time")
    private Date runEndTime;

    public Test(String projectName, String projectAuthor, String projectVersion, TestType type, String name, String runTitle) {
        if (projectName == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'projectName' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (projectAuthor == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'projectAuthor' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (projectVersion == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'projectVersion' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (type == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'type' when constructing entity of type " + this.getClass().getSimpleName());
        }
        if (name == null) {
            throw new IllegalArgumentException("Cannot provide null value for mandatory entity property 'name' when constructing entity of type " + this.getClass().getSimpleName());
        }
        this.projectName = projectName;
        this.projectAuthor = projectAuthor;
        this.projectVersion = projectVersion;
        this.type = type;
        this.name = name;
        this.status = TestStatus.CREATED;
        this.runTitle = runTitle;
        this.initStartTime = null;
        this.initEndTime = null;
        this.runStartTime = null;
        this.runEndTime = null;
    }

    Test() {
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectAuthor() {
        return this.projectAuthor;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public TestType getTestType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRunTitle() {
        return this.runTitle;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'status' of type " + this.getClass().getSimpleName());
        }
        this.status = status;
    }

    public Date getInitStartTime() {
        return this.initStartTime;
    }

    public void setInitStartTime(Date initStartTime) {
        if (this.initStartTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'initStartTime' once it has been set");
        }
        if (initStartTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'initStartTime' of type " + this.getClass().getSimpleName());
        }
        this.initStartTime = initStartTime;
    }

    public Date getInitEndTime() {
        return this.initEndTime;
    }

    public void setInitEndTime(Date initEndTime) {
        if (this.initEndTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'initEndTime' once it has been set");
        }
        if (initEndTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'initEndTime' of type " + this.getClass().getSimpleName());
        }
        this.initEndTime = initEndTime;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public void setRunStartTime(Date runStartTime) {
        if (this.runStartTime != null) {
            throw new IllegalStateException("Cannot modify entity property 'runStartTime' once it has been set");
        }
        if (runStartTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'runStartTime' of type " + this.getClass().getSimpleName());
        }
        this.runStartTime = runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public void setRunEndTime(Date runEndTime) {
        if (runEndTime == null) {
            throw new IllegalArgumentException("Cannot provide null value when setting entity property 'runEndTime' of type " + this.getClass().getSimpleName());
        }
        this.runEndTime = runEndTime;
    }

    public void setRunTitle(String runTitle) {
        this.runTitle = runTitle;
    }
}

