/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities;

import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="throughput_flow_result")
public class ThroughputFlowResult
extends BaseEntity
implements Comparable<ThroughputFlowResult> {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="throughput_flow_test", nullable=false)
    private ThroughputFlowTest test;
    @Column(name="frame_interval", nullable=false, unique=true)
    private long frameInterval;
    @Column(name="tx_byte_count", nullable=false)
    private long txBytes;
    @Column(name="configured_tx_byte_count", nullable=false)
    private long configuredTxBytes;
    @Column(name="rx_byte_count", nullable=false)
    private long rxBytes;
    @Column(name="rx_duration", nullable=false)
    private long duration;
    @Column(name="tx_packets", nullable=false)
    private long txPackets;
    @Column(name="rx_packets", nullable=false)
    private long rxPackets;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$EthernetThroughputType = ThroughputFlowResult.$SWITCH_TABLE$com$excentis$products$byteblower$results$testdata$data$utils$EthernetThroughputType();
    }

    protected ThroughputFlowResult() {
    }

    public ThroughputFlowResult(ThroughputFlowTest test, long frameInterval, long configuredTxFrames, long txFrames, long rxFrames, long duration, long txPackets, long rxPackets) {
        this.test = test;
        this.frameInterval = frameInterval;
        this.txBytes = txFrames;
        this.configuredTxBytes = configuredTxFrames;
        this.rxBytes = rxFrames;
        this.duration = duration;
        this.txPackets = txPackets;
        this.rxPackets = rxPackets;
    }

    public long getTxBytes() {
        return this.configuredTxBytes;
    }

    public long getRxBytes() {
        return this.rxBytes;
    }

    public long getFrameInterval() {
        return this.frameInterval;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTxPackets() {
        return this.txPackets;
    }

    public long getRxPackets() {
        return this.rxPackets;
    }

    public boolean success() {
        double loss = this.test.getAcceptableLoss() * 1.0000000002328306;
        return (double)this.txPackets <= (1.0 + loss) * (double)this.rxPackets;
    }

    public String toString() {
        return String.format("tx: %d rx: %d", this.txBytes, this.rxBytes);
    }

    public double rxFrameRate() {
        return (double)this.rxPackets / (1.0E-9 * (double)this.duration);
    }

    public double txFrameRate() {
        return (double)this.txPackets / (1.0E-9 * (double)this.duration);
    }

    public long rxBytes(EthernetThroughputType throughputType) {
        long virtualBytes = 0L;
        switch (throughputType) {
            case FRAME_FULL_LAYER1_INCL_IFG: {
                virtualBytes += 12L * this.rxPackets;
            }
            case FRAME_FULL_LAYER1_EXCL_IFG: {
                virtualBytes += 8L * this.rxPackets;
            }
            case FRAME_WITH_FCS: {
                virtualBytes += 4L * this.rxPackets;
            }
            case FRAME_ONLY: {
                virtualBytes += this.rxBytes;
            }
        }
        return virtualBytes;
    }

    public double rxByteRate(EthernetThroughputType throughputType) {
        return (double)this.rxBytes(throughputType) / (1.0E-9 * (double)this.duration);
    }

    @Override
    public int compareTo(ThroughputFlowResult oth) {
        return Long.compare(this.frameInterval, oth.frameInterval);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.configuredTxBytes ^ this.configuredTxBytes >>> 32);
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.frameInterval ^ this.frameInterval >>> 32);
        result = 31 * result + (int)(this.rxBytes ^ this.rxBytes >>> 32);
        result = 31 * result + (int)(this.rxPackets ^ this.rxPackets >>> 32);
        result = 31 * result + (this.test == null ? 0 : this.test.hashCode());
        result = 31 * result + (int)(this.txBytes ^ this.txBytes >>> 32);
        result = 31 * result + (int)(this.txPackets ^ this.txPackets >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThroughputFlowResult other = (ThroughputFlowResult)obj;
        if (this.configuredTxBytes != other.configuredTxBytes) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.frameInterval != other.frameInterval) {
            return false;
        }
        if (this.rxBytes != other.rxBytes) {
            return false;
        }
        if (this.rxPackets != other.rxPackets) {
            return false;
        }
        if (this.test == null ? other.test != null : !this.test.equals(other.test)) {
            return false;
        }
        if (this.txBytes != other.txBytes) {
            return false;
        }
        return this.txPackets == other.txPackets;
    }
}

