/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeModifierGrowing;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeModifierRandom;
import com.excentis.products.byteblower.results.testdata.data.entities.FbStreamTimingModifier;
import com.excentis.products.byteblower.results.testdata.data.entities.FbStreamTimingModifierMultiburst;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFrameSizeFixedReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFrameSizeModifierGrowingReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFrameSizeModifierRandomReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbStreamTimingModifierMultiburstReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import java.util.ArrayList;
import java.util.TreeSet;

public class FbFlowTemplateReader
extends BaseEntityReader<FbFlowTemplate> {
    private final String mixed = "Mixed";

    FbFlowTemplateReader(FbFlowTemplate entity) {
        super(entity);
    }

    private Double getVirtualNofBytes(EthernetThroughputType throughputType) {
        Double totalNofBytes = new Double(0.0);
        FbFlowTemplate frameBlastingFlow = (FbFlowTemplate)this.getEntity();
        for (FbFlowTemplateFrame frameBlastingFrame : frameBlastingFlow.getFrames()) {
            FbFrame fbFrame = frameBlastingFrame.getFrame();
            Double frameSize = null;
            if (fbFrame instanceof FbFrameSizeModifierGrowing) {
                FbFrameSizeModifierGrowing growing = (FbFrameSizeModifierGrowing)fbFrame;
                FbFrameSizeModifierGrowingReader growingReader = EntityReaderFactory.create(growing);
                frameSize = (double)(growingReader.getMinByteSize(throughputType) + growingReader.getMaxByteSize(throughputType)) / new Double(2.0);
            } else if (fbFrame instanceof FbFrameSizeModifierRandom) {
                FbFrameSizeModifierRandom random = (FbFrameSizeModifierRandom)fbFrame;
                FbFrameSizeModifierRandomReader randomReader = EntityReaderFactory.create(random);
                frameSize = (double)(randomReader.getMinByteSize(throughputType) + randomReader.getMaxByteSize(throughputType)) / new Double(2.0);
            } else if (fbFrame instanceof FbFrameSizeFixed) {
                FbFrameSizeFixed fixed = (FbFrameSizeFixed)fbFrame;
                FbFrameSizeFixedReader fixedReader = EntityReaderFactory.create(fixed);
                frameSize = new Double(fixedReader.getByteSize(throughputType));
            }
            int repeatCount = frameBlastingFrame.getRepeatCount();
            totalNofBytes = totalNofBytes + (double)repeatCount * frameSize;
        }
        return totalNofBytes;
    }

    private Double getVirtualNofBits(EthernetThroughputType throughputType) {
        Double bytes = this.getVirtualNofBytes(throughputType);
        Double bits = ThroughputReader.convertBytesToBits(bytes);
        return bits;
    }

    private int getVirtualNofFrames() {
        int totalNofFrames = 0;
        FbFlowTemplate frameBlastingFlow = (FbFlowTemplate)this.getEntity();
        for (FbFlowTemplateFrame frameBlastingFrame : frameBlastingFlow.getFrames()) {
            int repeatCount = frameBlastingFrame.getRepeatCount();
            totalNofFrames += repeatCount;
        }
        return totalNofFrames;
    }

    public Double getThroughput(EthernetThroughputType throughputType) {
        return this.getThroughput(throughputType, DataRateUnit.BIT_PER_SECOND);
    }

    public Double getThroughput(EthernetThroughputType throughputType, DataRateUnit unit) {
        Double virtualNofBits = this.getVirtualNofBits(throughputType);
        if (virtualNofBits.compareTo(0.0) == 0) {
            return 0.0;
        }
        int virtualNofFrames = this.getVirtualNofFrames();
        Long frameIntervalInNs = this.getFrameInterval();
        Double totalIntervalNs = new Double(virtualNofFrames) * (double)frameIntervalInNs.longValue();
        virtualNofBits = virtualNofBits * ThroughputReader.NANOSECONDS_IN_SECOND;
        Double throughput = virtualNofBits / totalIntervalNs;
        if (this.isBursty()) {
            throughput = this.makeBursty(throughput);
        }
        return ThroughputReader.convertTo(throughput, unit);
    }

    private Double makeBursty(Double throughput) {
        FbStreamTimingModifier timingModifier = this.getTimingModifier();
        FbStreamTimingModifierMultiburst multipleBurst = (FbStreamTimingModifierMultiburst)timingModifier;
        FbStreamTimingModifierMultiburstReader multipleBurstReader = EntityReaderFactory.create(multipleBurst);
        Long nofFramesPerBurst = multipleBurstReader.getNofFramesPerBurst();
        Long burstDuration = this.getBurstDuration(nofFramesPerBurst);
        Long interBurstGap = multipleBurstReader.getInterBurstGap();
        Long burstInterval = burstDuration + interBurstGap;
        throughput = throughput * (double)burstDuration.longValue();
        throughput = throughput / (double)burstInterval.longValue();
        return throughput;
    }

    private Long getBurstDuration(Long nofFrames) {
        Long frameInterval = this.getFrameInterval();
        Long burstDuration = frameInterval * nofFrames;
        return burstDuration;
    }

    private boolean isBursty() {
        return this.getTimingModifier() != null;
    }

    public Long getFrameInterval() {
        return this.getFrameBlastingFlow().getFrameInterval();
    }

    private FbFlowTemplate getFrameBlastingFlow() {
        return (FbFlowTemplate)this.getEntity();
    }

    public FbStreamTimingModifier getTimingModifier() {
        return this.getFrameBlastingFlow().getFbStreamTimingModifier();
    }

    public String getName() {
        return ((FbFlowTemplate)this.entity).getName();
    }

    public Double getFrameRate() {
        Long frameIntervalNanoseconds = ((FbFlowTemplate)this.entity).getFrameInterval();
        Double frameRate = 1.0E9 / (double)frameIntervalNanoseconds.longValue();
        return frameRate;
    }

    public String getFrameSizeInfo() {
        FbFlowTemplate frameBlastingFlow = (FbFlowTemplate)this.getEntity();
        TreeSet<Integer> frameSizes = new TreeSet<Integer>();
        for (FbFlowTemplateFrame frameBlastingFrame : frameBlastingFlow.getFrames()) {
            FbFrame fbFrame = frameBlastingFrame.getFrame();
            if (fbFrame instanceof FbFrameSizeModifierGrowing) {
                return "Mixed";
            }
            if (fbFrame instanceof FbFrameSizeModifierRandom) {
                return "Mixed";
            }
            if (!(fbFrame instanceof FbFrameSizeFixed)) continue;
            FbFrameSizeFixed fixed = (FbFrameSizeFixed)fbFrame;
            frameSizes.add(fixed.getSize());
        }
        if (frameSizes.isEmpty()) {
            return "No frame size";
        }
        ArrayList<String> strSizes = new ArrayList<String>();
        for (Integer size : frameSizes) {
            String current = String.format("%,d", size);
            strSizes.add(current);
        }
        String result = String.join((CharSequence)" | ", strSizes);
        return result;
    }
}

