/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.AbstractFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;

public class HttpFlowInstanceReader
extends AbstractFlowInstanceReader<HttpFlowInstance> {
    HttpFlowInstanceReader(HttpFlowInstance entity) {
        super(entity);
    }

    public static HttpSession getSourceHttpSession(HttpFlowInstance httpFlowInstance) {
        HttpRequestMethod requestMethod = httpFlowInstance.getRequestMethod();
        if (requestMethod == null) {
            return null;
        }
        switch (requestMethod) {
            case GET: {
                return httpFlowInstance.getServerHttpSession();
            }
            case PUT: {
                return httpFlowInstance.getClientHttpSession();
            }
        }
        throw new IllegalStateException("RequestMethod of Flow '" + httpFlowInstance.getFlow().getName() + "' is of unexpected type " + (Object)((Object)requestMethod));
    }

    public static boolean isSourceHttpSession(HttpFlowInstance httpFlowInstance, HttpSession httpSession) {
        if (httpSession == null) {
            return false;
        }
        return httpSession.equals(HttpFlowInstanceReader.getSourceHttpSession(httpFlowInstance));
    }

    public static HttpSession getDestinationHttpSession(HttpFlowInstance httpFlowInstance) {
        HttpSession sourceSession = HttpFlowInstanceReader.getSourceHttpSession(httpFlowInstance);
        if (sourceSession == null) {
            return null;
        }
        if (sourceSession.equals(httpFlowInstance.getServerHttpSession())) {
            return httpFlowInstance.getClientHttpSession();
        }
        return httpFlowInstance.getServerHttpSession();
    }

    public static boolean isDestinationHttpSession(HttpFlowInstance httpFlowInstance, HttpSession httpSession) {
        if (httpSession == null) {
            return false;
        }
        return httpSession.equals(HttpFlowInstanceReader.getDestinationHttpSession(httpFlowInstance));
    }

    public boolean isValid(HttpFlowInstance httpFlowInstance) {
        HttpRequestMethod method = httpFlowInstance.getRequestMethod();
        return method != null && (httpFlowInstance.getClientHttpSession() != null || httpFlowInstance.getServerHttpSession() != null);
    }

    public HttpSession getSourceHttpSession() {
        return HttpFlowInstanceReader.getSourceHttpSession((HttpFlowInstance)this.entity);
    }

    public HttpSessionReader getSourceHttpSessionReader() {
        return EntityReaderFactory.create(this.getSourceHttpSession());
    }

    public HttpSession getDestinationHttpSession() {
        return HttpFlowInstanceReader.getDestinationHttpSession((HttpFlowInstance)this.entity);
    }

    public HttpSessionReader getDestinationHttpSessionReader() {
        return EntityReaderFactory.create(this.getDestinationHttpSession());
    }

    public PortReader getSourceReader() {
        HttpSession sourceSession = this.getSourceHttpSession();
        if (sourceSession == null) {
            return null;
        }
        return EntityReaderFactory.create(sourceSession.getHttpApplication().getPort());
    }

    public PortReader getDestinationReader() {
        HttpSession destinationSession = this.getDestinationHttpSession();
        if (destinationSession == null) {
            return null;
        }
        return EntityReaderFactory.create(destinationSession.getHttpApplication().getPort());
    }

    public String getStart() {
        Long nanos = ((HttpFlowInstance)this.entity).getStartTime();
        if (nanos == null) {
            return null;
        }
        HighResolutionCalendar start = new HighResolutionCalendar(nanos);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)start);
    }

    public String getDuration() {
        Long nanos = ((HttpFlowInstance)this.entity).getDuration();
        if (nanos == null) {
            return null;
        }
        HighResolutionCalendar start = new HighResolutionCalendar(nanos);
        return HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)start);
    }

    public long getDurationNanoseconds() {
        Long nanos = ((HttpFlowInstance)this.entity).getDuration();
        if (nanos == null) {
            return 0L;
        }
        return nanos;
    }

    public Long calculateTTFBNanoseconds(TestDataPersistenceController pc) {
        HttpSession client = ((HttpFlowInstance)this.entity).getClientHttpSession();
        CumulativeSnapshotManager gg = new CumulativeSnapshotManager(pc);
        TcpSessionSnapshotSynSent start = gg.findSynSent(client.getTcpSession());
        Long firstByte = client.getRxFirstByteTime();
        if (start != null && start.getTimeLastSynSent() != 9L && firstByte != null) {
            return firstByte - start.getTimeLastSynSent();
        }
        return null;
    }

    public Double getRateLimit(DataRateUnit dataRateUnit) {
        Long rateLimitBitsps = ((HttpFlowInstance)this.entity).getFlowTemplate().getRateLimitation();
        if (rateLimitBitsps == null) {
            return null;
        }
        return ThroughputReader.convertThroughput(rateLimitBitsps.doubleValue(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }
}

