/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.entities.readers;

import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.core.BaseEntityReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.ThroughputReader;
import com.excentis.products.byteblower.results.testdata.data.utils.UnitReader;
import java.util.Date;

public class TcpSessionSnapshotReader
extends BaseEntityReader<TcpSessionSnapshot> {
    TcpSessionSnapshotReader(TcpSessionSnapshot entity) {
        super(entity);
    }

    public Double getTxThroughput(DataRateUnit dataRateUnit) {
        return this.isZero() ? TcpSessionSnapshotReader.zeroValue() : ThroughputReader.convertThroughput(this.getTxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getRxThroughput(DataRateUnit dataRateUnit) {
        return this.isZero() ? TcpSessionSnapshotReader.zeroValue() : ThroughputReader.convertThroughput(this.getRxThroughputBps(), DataRateUnit.BIT_PER_SECOND, dataRateUnit);
    }

    public Double getTxThroughputBps() {
        if (this.isZero()) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        TcpSessionSnapshotTxCounters tx = ((TcpSessionSnapshot)this.entity).getTxCounters();
        long byteCount = tx == null ? 0L : tx.getBytesTotal();
        Double val = ThroughputReader.convertBytesToBits(Double.valueOf(byteCount)) / durationSeconds;
        return val;
    }

    public Double getRxThroughputBps() {
        if (this.isZero()) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        Double durationSeconds = this.getSnapshotDurationSeconds();
        if (durationSeconds == null || durationSeconds == 0.0) {
            return null;
        }
        TcpSessionSnapshotRxCounters rx = ((TcpSessionSnapshot)this.entity).getRxCounters();
        long byteCount = rx == null ? 0L : rx.getBytesTotal();
        Double val = ThroughputReader.convertBytesToBits(Double.valueOf(byteCount)) / durationSeconds;
        return val;
    }

    public Long getSnapshotDurationNs() {
        return ((TcpSessionSnapshot)this.entity).getSnapshotDuration();
    }

    public Double getSnapshotDurationSeconds() {
        if (((TcpSessionSnapshot)this.entity).getSnapshotDuration() == 0L) {
            return null;
        }
        return UnitReader.convert((double)((TcpSessionSnapshot)this.entity).getSnapshotDuration(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.BASE);
    }

    public Long getSnapshotTimeNs() {
        return ((TcpSessionSnapshot)this.entity).getSnapshotTime();
    }

    public Long getSnapshotTimeMs() {
        Long snapshotNs = this.getSnapshotTimeNs();
        long ms = Math.round(UnitReader.convert(snapshotNs, UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.MILLI));
        return ms;
    }

    public Date getSnapshotTime() {
        return new Date(this.getSnapshotTimeMs());
    }

    public Long getCorrectedSnapshotTimeMs() {
        Long ms = this.getSnapshotTimeMs();
        ms = this.timeZoneOffset(ms);
        return ms;
    }

    public Long getRoundTripTime() {
        return this.isZero() ? 0L : ((TcpSessionSnapshot)this.entity).getRoundTripTimeCurrent();
    }

    public Long getMaxRoundTripTime() {
        return this.isZero() ? 0L : ((TcpSessionSnapshot)this.entity).getRoundTripTimeMaximum();
    }

    public Long getMinRoundTripTime() {
        return this.isZero() ? 0L : ((TcpSessionSnapshot)this.entity).getRoundTripTimeMinimum();
    }

    public Long getCongestionWindow() {
        return this.isZero() ? 0L : ((TcpSessionSnapshot)this.entity).getCongestionWindowCurrent();
    }

    public Long getReceiveWindow() {
        return this.isZero() ? 0L : ((TcpSessionSnapshot)this.entity).getReceiverWindowCurrent();
    }

    public Double getCongestionWindowInKB() {
        if (this.isZero()) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        long cw = ((TcpSessionSnapshot)this.entity).getCongestionWindowCurrent();
        return UnitReader.convert(cw, UnitReader.UnitPrefix.BASE, UnitReader.UnitPrefix.KILO);
    }

    public Double getReceiveWindowInKB() {
        if (this.isZero()) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        long rw = ((TcpSessionSnapshot)this.entity).getReceiverWindowCurrent();
        return UnitReader.convert(rw, UnitReader.UnitPrefix.BASE, UnitReader.UnitPrefix.KILO);
    }

    public Double getRoundTripTimeMs() {
        if (this.isZero()) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        Long rtt = this.getRoundTripTime();
        return UnitReader.convert(rtt.doubleValue(), UnitReader.UnitPrefix.NANO, UnitReader.UnitPrefix.MILLI);
    }

    public Double getRetransmissions() {
        if (this.isZero() || ((TcpSessionSnapshot)this.entity).getRetransmissions() == null) {
            return TcpSessionSnapshotReader.zeroValue();
        }
        Double val = ((TcpSessionSnapshot)this.entity).getRetransmissions().getTotalRetransmissions();
        return val;
    }

    public String getTooltipText() {
        return this.getSnapshotTime().toString();
    }

    public Double getRoundTripTime(LatencyUnit unit) {
        Long ns = this.getRoundTripTime();
        return LatencyUnit.convert(ns, LatencyUnit.NANOSECONDS, unit);
    }

    public Double getMaxRoundTripTime(LatencyUnit unit) {
        Long ns = this.getMaxRoundTripTime();
        return LatencyUnit.convert(ns, LatencyUnit.NANOSECONDS, unit);
    }

    public Double getMinRoundTripTime(LatencyUnit unit) {
        Long ns = this.getMinRoundTripTime();
        return LatencyUnit.convert(ns, LatencyUnit.NANOSECONDS, unit);
    }
}

