/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

public class ConversionHelper {
    private ConversionHelper() {
    }

    static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    static byte hexToByte(String hexString) {
        int firstDigit = ConversionHelper.toDigit(hexString.charAt(0));
        int secondDigit = ConversionHelper.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }

    static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer hexStringBuffer = new StringBuffer();
        int i = 0;
        while (i < byteArray.length) {
            hexStringBuffer.append(ConversionHelper.byteToHex(byteArray[i]));
            ++i;
        }
        return hexStringBuffer.toString();
    }

    static byte[] hexStringToByteArray(String hexString) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        byte[] bytes = new byte[hexString.length() / 2];
        int i = 0;
        while (i < hexString.length()) {
            bytes[i / 2] = ConversionHelper.hexToByte(hexString.substring(i, i + 2));
            i += 2;
        }
        return bytes;
    }
}

