/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.datalibs.DatabaseModifier;
import com.excentis.products.byteblower.datalibs.DatabaseType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DatabaseUpdater
implements DatabaseModifier {
    private static final Logger LOGGER = Logger.getGlobal();

    private int version(int ... nums) {
        int versionNumber = 0;
        int ctr = 0;
        while (ctr < nums.length && ctr < 4) {
            versionNumber = (versionNumber << 8) + nums[ctr];
            ++ctr;
        }
        return versionNumber;
    }

    private void setVersion(Connection connection, int major, int minor, int patch) throws SQLException {
        String versionString = String.valueOf(major) + "." + minor + "." + patch;
        PreparedStatement statement = connection.prepareStatement("UPDATE TEST SET PROJECT_VERSION='" + versionString + "'");
        statement.execute();
    }

    private int getVersion(Connection connection) throws SQLException {
        ResultSet set = connection.prepareStatement("SELECT PROJECT_VERSION FROM TEST").executeQuery();
        if (!set.next()) {
            return this.version(99, 99, 99);
        }
        String version = set.getString(1);
        String[] strNums = version.split(Pattern.quote("."));
        int[] nums = new int[strNums.length];
        int ctr = 0;
        while (ctr < strNums.length) {
            String strNumber = strNums[ctr];
            try {
                int versionPart;
                nums[ctr] = versionPart = Integer.parseInt(strNumber);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.WARNING, "Does not recognize test database version: " + version);
                return -1;
            }
            ++ctr;
        }
        return this.version(nums);
    }

    public boolean doUpdate(Connection connection, DatabaseType type) throws SQLException {
        boolean success = true;
        int connectionVersion = this.getVersion(connection);
        if (connectionVersion < this.version(2, 2, 99)) {
            success = this.update_2_2_99(connection);
        }
        if (connectionVersion < this.version(2, 4, 99)) {
            success = this.update_2_4_99(connection);
        }
        if (connectionVersion < this.version(2, 5, 99)) {
            success = this.update_2_5_99(connection);
        }
        if (connectionVersion < this.version(2, 6, 99)) {
            success = this.update_2_6_99(connection);
        }
        if (connectionVersion < this.version(2, 7, 99)) {
            success = this.update_2_7_100(connection);
        }
        if (connectionVersion < this.version(2, 8, 99)) {
            success = this.update_2_8_100(connection);
        }
        if (connectionVersion < this.version(2, 21, 99)) {
            success = this.update_2_21_100(connection);
        }
        return success;
    }

    private boolean update_2_21_100(Connection connection) throws SQLException {
        this.addColumn(connection, "http_flow_template", "is_l4s_enabled", "TINYINT(1)", "0");
        connection.prepareStatement("UPDATE tcp_session_snapshot SET slow_start_threshold_minimum = 0").execute();
        connection.prepareStatement("UPDATE tcp_session_snapshot SET slow_start_threshold_maximum = 0").execute();
        return true;
    }

    private boolean update_2_8_100(Connection connection) throws SQLException {
        this.addColumn(connection, "http_flow_instance", "restarts", "BIGINT(20)", "0");
        return false;
    }

    private boolean update_2_7_100(Connection connect) throws SQLException {
        this.addColumn(connect, "flow_instance", "parent", "BIGINT(20)", "-1");
        return true;
    }

    private boolean update_2_6_99(Connection connect) throws SQLException {
        this.latencySnapshot_2_5_99(connect);
        return true;
    }

    private void latencySnapshot_2_5_99(Connection connect) throws SQLException {
        this.addColumn(connect, "fb_latency", "packet_count_invalid", "BIGINT(20)", "0");
    }

    private boolean update_2_2_99(Connection connect) throws SQLException {
        this.vlanUpdate_2_2_99(connect);
        this.natConfig_2_2_99(connect);
        this.tcpUpdate_2_2_99(connect);
        this.setVersion(connect, 2, 2, 99);
        return true;
    }

    private boolean update_2_4_99(Connection connect) throws SQLException {
        this.tosUpdate_2_4_99(connect);
        this.dockedUpdate_2_4_99(connect);
        this.setVersion(connect, 2, 4, 99);
        return true;
    }

    private boolean update_2_5_99(Connection connect) throws SQLException {
        this.runTitleUpdate_2_5_99(connect);
        this.problemResolutionUpdate_2_5_99(connect);
        this.knowledgebaseColumn_2_5_99(connect);
        this.serverColumn(connect);
        this.setVersion(connect, 2, 5, 99);
        return true;
    }

    private void serverColumn(Connection connect) throws SQLException {
        this.addColumn(connect, "server", "name", "VARCHAR(128)", "");
        this.addColumn(connect, "server", "DESCRIPTION", "VARCHAR(21844)", "");
        this.addColumn(connect, "server", "UUID", "VARCHAR(128)", "");
    }

    private void knowledgebaseColumn_2_5_99(Connection connect) throws SQLException {
        this.addColumn(connect, "event", "knowledgebase_link", "VARCHAR(1024)");
        PreparedStatement descriptions = connect.prepareStatement("SELECT id, description FROM event");
        ResultSet results = descriptions.executeQuery();
        String replacement = "";
        class Row {
            long id;
            String description;
            String link;

            public Row(long id, String description, String link) {
                this.id = id;
                this.description = description;
                this.link = link;
            }
        }
        ArrayList<Row> updatedRows = new ArrayList<Row>();
        while (results.next()) {
            int start;
            String description = results.getString("description");
            if (description == null) {
                description = new String();
            }
            long id = results.getLong("id");
            String ref = "https://support.excentis.com";
            if (!description.contains("https://support.excentis.com")) continue;
            int idx = start = description.indexOf("https://support.excentis.com");
            int end = -1;
            while (idx < description.length()) {
                char ch = description.charAt(idx);
                if (ch == ' ' || ch == '\n' || ch == '\t') {
                    end = idx - 1;
                }
                ++idx;
            }
            if (idx == description.length()) {
                end = idx;
            }
            if (end <= 0 || start >= end) continue;
            String hyperlink = description.substring(start, end);
            description = description.replace(hyperlink, "");
            updatedRows.add(new Row(id, description, hyperlink));
        }
        results.close();
        for (Row row : updatedRows) {
            PreparedStatement stmt = connect.prepareStatement("UPDATE event set (description, knowledgebase_link) = SELECT $1, $2 WHERE id = $3");
            stmt.setString(1, row.description);
            stmt.setString(2, row.link);
            stmt.setLong(3, row.id);
            stmt.executeUpdate();
        }
    }

    private void problemResolutionUpdate_2_5_99(Connection connect) throws SQLException {
        String ALTER_EVENT = "ALTER TABLE `event` ADD IF NOT EXISTS `suggestion` VARCHAR(21844) NOT NULL DEFAULT ''";
        connect.prepareStatement("ALTER TABLE `event` ADD IF NOT EXISTS `suggestion` VARCHAR(21844) NOT NULL DEFAULT ''").execute();
    }

    private void tcpUpdate_2_2_99(Connection connect) throws SQLException {
        String ALTER_HTTP_SESSION = "ALTER TABLE `http_session` ADD ( `tx_header_byte_count` BIGINT(20) NULL DEFAULT 0, `tx_payload_byte_count` BIGINT(20) NULL DEFAULT 0, `rx_header_byte_count` BIGINT(20) NULL DEFAULT 0, `rx_payload_byte_count` BIGINT(20) NULL DEFAULT 0) ";
        String TMP_TCP_SESSION = "CREATE TABLE `tcp_session_tmp` AS SELECT * FROM `tcp_session`";
        String DROP_TCP_SESSION = "DROP TABLE `tcp_session`";
        String CREATE_TCP_SESSION = "  CREATE TABLE IF NOT EXISTS `tcp_session` (    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,    `state` VARCHAR(40) NULL,    `ca_algorithm` VARCHAR(40) NULL,    `maximum_segment_size` INT(10) NULL,    PRIMARY KEY (`id`))";
        String POPULATE_TCP_SESSION = "INSERT INTO `tcp_session` (id, state, ca_algorithm, maximum_segment_size) SELECT tcp.id, tcp.state, tcp.ca_algorithm, tcp.maximum_segment_size  FROM `tcp_session_tmp` as tcp";
        String TMP_TCP_SESSION_SNAPSHOT = "CREATE TABLE `tcp_session_snapshot_tmp` AS SELECT * FROM `tcp_session_snapshot`";
        String DROP_TCP_SESSION_SNAPSHOT = "DROP TABLE `tcp_session_snapshot`";
        String CREATE_TCP_SESSION_SNAPSHOT = "    CREATE TABLE IF NOT EXISTS `tcp_session_snapshot` (            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,            `tcp_session_id` BIGINT(20) NOT NULL,            `snapshot_time` BIGINT(20) NOT NULL,            `snapshot_duration` BIGINT(20) NOT NULL,            `connection_state` VARCHAR(40) NOT NULL,            `congestion_window_minimum` BIGINT(20) NOT NULL,            `congestion_window_current` BIGINT(20) NOT NULL,            `congestion_window_maximum` BIGINT(20) NOT NULL,            `receiver_window_minimum` BIGINT(20) NOT NULL,            `receiver_window_current` BIGINT(20) NOT NULL,            `receiver_window_maximum` BIGINT(20) NOT NULL,            `slow_start_threshold_minimum` BIGINT(20) NOT NULL,            `slow_start_threshold_current` BIGINT(20) NOT NULL,            `slow_start_threshold_maximum` BIGINT(20) NOT NULL,            `roundtriptime_minimum` BIGINT(20) NOT NULL,            `roundtriptime_current` BIGINT(20) NOT NULL,            `roundtriptime_maximum` BIGINT(20) NOT NULL,            PRIMARY KEY (`id`),            INDEX `fk_tcp_session_snapshot_owner` (`tcp_session_id` ASC),            CONSTRAINT `fk_tcp_session_snapshot_owner`              FOREIGN KEY (`tcp_session_id`)              REFERENCES `tcp_session` (`id`)              ON DELETE NO ACTION              ON UPDATE NO ACTION)";
        String CONVERT_TCPSESSION_SNAPSHOT = "    INSERT INTO `tcp_session_snapshot` (tcp_session_id, snapshot_time, snapshot_duration,                                         connection_state, congestion_window_minimum,                                         congestion_window_current, congestion_window_maximum,                                         receiver_window_minimum, receiver_window_current,                                         receiver_window_maximum, slow_start_threshold_minimum,                                         slow_start_threshold_current, slow_start_threshold_maximum,                                         roundtriptime_minimum, roundtriptime_current,                                         roundtriptime_maximum)                        SELECT tcp.id, 0L, tcp.snapshot_resolution, tcp.state, 0,0,0, 0,0,0, 0,0,0,                 tcp.roundtriptime_minimum, tcp.roundtriptime_current, tcp.roundtriptime_maximum         FROM tcp_session_tmp as tcp ";
        String CUMULATIVE_TCPSESSION_SNAPSHOT = "INSERT INTO `tcp_session_cumulative_snapshot` (`snapshot_id`)SELECT snap.id FROM tcp_session_snapshot as snap";
        String CUMULATIVE_RETRANSMIT_COUNTER = "INSERT INTO `tcp_session_snapshot_retransmission_counters`  (`snapshot_id`,                 retransmission_count_slow,    retransmission_count_fast,    retransmission_count_total) SELECT session.id , session.retransmission_count_slow,session.retransmission_count_fast,session.retransmission_count_slow + session.retransmission_count_fast FROM tcp_session_tmp as session";
        String DROP_TCP_SESSION_TMP = "DROP TABLE `tcp_session_tmp`";
        String DROP_TCP_SESSION_SNAPSHOT_TMP = "DROP TABLE `tcp_session_snapshot_tmp`";
        connect.prepareStatement("ALTER TABLE `http_session` ADD ( `tx_header_byte_count` BIGINT(20) NULL DEFAULT 0, `tx_payload_byte_count` BIGINT(20) NULL DEFAULT 0, `rx_header_byte_count` BIGINT(20) NULL DEFAULT 0, `rx_payload_byte_count` BIGINT(20) NULL DEFAULT 0) ").execute();
        connect.prepareStatement("CREATE TABLE `tcp_session_tmp` AS SELECT * FROM `tcp_session`").execute();
        connect.prepareStatement("DROP TABLE `tcp_session`").execute();
        connect.prepareStatement("  CREATE TABLE IF NOT EXISTS `tcp_session` (    `id` BIGINT(20) NOT NULL AUTO_INCREMENT,    `state` VARCHAR(40) NULL,    `ca_algorithm` VARCHAR(40) NULL,    `maximum_segment_size` INT(10) NULL,    PRIMARY KEY (`id`))").execute();
        connect.prepareStatement("INSERT INTO `tcp_session` (id, state, ca_algorithm, maximum_segment_size) SELECT tcp.id, tcp.state, tcp.ca_algorithm, tcp.maximum_segment_size  FROM `tcp_session_tmp` as tcp").execute();
        connect.prepareStatement("CREATE TABLE `tcp_session_snapshot_tmp` AS SELECT * FROM `tcp_session_snapshot`").execute();
        connect.prepareStatement("DROP TABLE `tcp_session_snapshot`").execute();
        connect.prepareStatement("    CREATE TABLE IF NOT EXISTS `tcp_session_snapshot` (            `id` BIGINT(20) NOT NULL AUTO_INCREMENT,            `tcp_session_id` BIGINT(20) NOT NULL,            `snapshot_time` BIGINT(20) NOT NULL,            `snapshot_duration` BIGINT(20) NOT NULL,            `connection_state` VARCHAR(40) NOT NULL,            `congestion_window_minimum` BIGINT(20) NOT NULL,            `congestion_window_current` BIGINT(20) NOT NULL,            `congestion_window_maximum` BIGINT(20) NOT NULL,            `receiver_window_minimum` BIGINT(20) NOT NULL,            `receiver_window_current` BIGINT(20) NOT NULL,            `receiver_window_maximum` BIGINT(20) NOT NULL,            `slow_start_threshold_minimum` BIGINT(20) NOT NULL,            `slow_start_threshold_current` BIGINT(20) NOT NULL,            `slow_start_threshold_maximum` BIGINT(20) NOT NULL,            `roundtriptime_minimum` BIGINT(20) NOT NULL,            `roundtriptime_current` BIGINT(20) NOT NULL,            `roundtriptime_maximum` BIGINT(20) NOT NULL,            PRIMARY KEY (`id`),            INDEX `fk_tcp_session_snapshot_owner` (`tcp_session_id` ASC),            CONSTRAINT `fk_tcp_session_snapshot_owner`              FOREIGN KEY (`tcp_session_id`)              REFERENCES `tcp_session` (`id`)              ON DELETE NO ACTION              ON UPDATE NO ACTION)").execute();
        connect.prepareStatement("    INSERT INTO `tcp_session_snapshot` (tcp_session_id, snapshot_time, snapshot_duration,                                         connection_state, congestion_window_minimum,                                         congestion_window_current, congestion_window_maximum,                                         receiver_window_minimum, receiver_window_current,                                         receiver_window_maximum, slow_start_threshold_minimum,                                         slow_start_threshold_current, slow_start_threshold_maximum,                                         roundtriptime_minimum, roundtriptime_current,                                         roundtriptime_maximum)                        SELECT tcp.id, 0L, tcp.snapshot_resolution, tcp.state, 0,0,0, 0,0,0, 0,0,0,                 tcp.roundtriptime_minimum, tcp.roundtriptime_current, tcp.roundtriptime_maximum         FROM tcp_session_tmp as tcp ").execute();
        connect.prepareStatement("INSERT INTO `tcp_session_cumulative_snapshot` (`snapshot_id`)SELECT snap.id FROM tcp_session_snapshot as snap").execute();
        connect.prepareStatement("INSERT INTO `tcp_session_snapshot_retransmission_counters`  (`snapshot_id`,                 retransmission_count_slow,    retransmission_count_fast,    retransmission_count_total) SELECT session.id , session.retransmission_count_slow,session.retransmission_count_fast,session.retransmission_count_slow + session.retransmission_count_fast FROM tcp_session_tmp as session").execute();
        connect.prepareStatement("DROP TABLE `tcp_session_tmp`").execute();
        connect.prepareStatement("DROP TABLE `tcp_session_snapshot_tmp`").execute();
    }

    private void natConfig_2_2_99(Connection connect) throws SQLException {
        String POPULATE_NATCONFIG_NAMES = "INSERT into `ipv4_nat_configuration`(`name`) SELECT DISTINCT NAT_CONFIGURATION FROM LAYER3_IPV4 WHERE NAT_CONFIGURATION <> 'NONE' ";
        String METHOD_ADDRESS = "ALTER TABLE `nat_mapping_address` ADD (`method` VARCHAR(21844) NULL DEFAULT 'Automatic Discovery')";
        String METHOD_PORT = "ALTER TABLE `nat_mapping_port` ADD (`method` VARCHAR(21844) NULL DEFAULT 'Automatic Discovery')";
        String CREATE_TO_TEMP = "CREATE TABLE `LAYER3_IPV4_TEMP` AS SELECT * FROM `LAYER3_IPV4`";
        String DROP_ORIG_TABLE = "DROP table `LAYER3_IPV4`";
        String CREATE_LAYER3_IPV4_TABLE = "CREATE TABLE IF NOT EXISTS `layer3_ipv4` (   `id` BIGINT(20) NOT NULL,  `method` VARCHAR(40) NOT NULL,  `dhcp_configuration_id` BIGINT(20) NULL,  `static_configuration_id` BIGINT(20) NULL,  `nat_configuration_id` INT(20) NULL,  PRIMARY KEY (`id`),  INDEX `fk_layer3_ipv4_parent` (`id` ASC),  INDEX `fk_layer3_ipv4_dhcpconfig` (`dhcp_configuration_id` ASC),  INDEX `fk_layer3_ipv4_staticconfig` (`static_configuration_id` ASC),  INDEX `fk_layer3_ipv4_natconfig_idx` (`nat_configuration_id` ASC),  CONSTRAINT `fk_layer3_ipv4_parent`    FOREIGN KEY (`id`)    REFERENCES `layer3` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_dhcpconfig`    FOREIGN KEY (`dhcp_configuration_id`)    REFERENCES `layer3_ipv4_configuration_dhcpv4` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_staticconfig`    FOREIGN KEY (`static_configuration_id`)    REFERENCES `layer3_ipv4_configuration_static` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_natconfig`    FOREIGN KEY (`nat_configuration_id`)    REFERENCES `ipv4_nat_configuration` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION)";
        String POPULATE_LAYER3_IPV4_table = "INSERT INTO `layer3_ipv4` SELECT orig.id, orig.method, orig.dhcp_configuration_id, orig.static_configuration_id, NAT.id FROM LAYER3_IPV4_TEMP as orig                                                                   LEFT OUTER JOIN ipv4_nat_configuration as NAT ON orig.NAT_CONFIGURATION = NAT.name";
        String DROP_TEMP_TABLE = "DROP TABLE LAYER3_IPV4_TEMP";
        connect.prepareStatement("INSERT into `ipv4_nat_configuration`(`name`) SELECT DISTINCT NAT_CONFIGURATION FROM LAYER3_IPV4 WHERE NAT_CONFIGURATION <> 'NONE' ").execute();
        connect.prepareStatement("ALTER TABLE `nat_mapping_address` ADD (`method` VARCHAR(21844) NULL DEFAULT 'Automatic Discovery')").execute();
        connect.prepareStatement("ALTER TABLE `nat_mapping_port` ADD (`method` VARCHAR(21844) NULL DEFAULT 'Automatic Discovery')").execute();
        connect.prepareStatement("CREATE TABLE `LAYER3_IPV4_TEMP` AS SELECT * FROM `LAYER3_IPV4`").execute();
        connect.prepareStatement("DROP table `LAYER3_IPV4`").execute();
        connect.prepareStatement("CREATE TABLE IF NOT EXISTS `layer3_ipv4` (   `id` BIGINT(20) NOT NULL,  `method` VARCHAR(40) NOT NULL,  `dhcp_configuration_id` BIGINT(20) NULL,  `static_configuration_id` BIGINT(20) NULL,  `nat_configuration_id` INT(20) NULL,  PRIMARY KEY (`id`),  INDEX `fk_layer3_ipv4_parent` (`id` ASC),  INDEX `fk_layer3_ipv4_dhcpconfig` (`dhcp_configuration_id` ASC),  INDEX `fk_layer3_ipv4_staticconfig` (`static_configuration_id` ASC),  INDEX `fk_layer3_ipv4_natconfig_idx` (`nat_configuration_id` ASC),  CONSTRAINT `fk_layer3_ipv4_parent`    FOREIGN KEY (`id`)    REFERENCES `layer3` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_dhcpconfig`    FOREIGN KEY (`dhcp_configuration_id`)    REFERENCES `layer3_ipv4_configuration_dhcpv4` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_staticconfig`    FOREIGN KEY (`static_configuration_id`)    REFERENCES `layer3_ipv4_configuration_static` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION,  CONSTRAINT `fk_layer3_ipv4_natconfig`    FOREIGN KEY (`nat_configuration_id`)    REFERENCES `ipv4_nat_configuration` (`id`)    ON DELETE NO ACTION    ON UPDATE NO ACTION)").execute();
        connect.prepareStatement("INSERT INTO `layer3_ipv4` SELECT orig.id, orig.method, orig.dhcp_configuration_id, orig.static_configuration_id, NAT.id FROM LAYER3_IPV4_TEMP as orig                                                                   LEFT OUTER JOIN ipv4_nat_configuration as NAT ON orig.NAT_CONFIGURATION = NAT.name").execute();
        connect.prepareStatement("DROP TABLE LAYER3_IPV4_TEMP").execute();
    }

    private void vlanUpdate_2_2_99(Connection connect) throws SQLException {
        String REMOVE_VLAN_NAME_COLUMN = "ALTER TABLE `LAYER25_VLAN_CONFIGURATION` DROP COLUMN `NAME`";
        connect.prepareStatement("ALTER TABLE `LAYER25_VLAN_CONFIGURATION` DROP COLUMN `NAME`").execute();
    }

    private void tosUpdate_2_4_99(Connection connect) throws SQLException {
        this.addColumn(connect, "flow_instance", "tos", "VARCHAR(40)");
    }

    @Deprecated
    private void addColumn(Connection connection, String tableName, String columnName, String type) throws SQLException {
        this.addColumn(connection, tableName, columnName, type, null);
    }

    private void addColumn(Connection connection, String tableName, String columnName, String type, String defaultValue) throws SQLException {
        String addColumn = "ALTER TABLE `" + tableName + "` " + "ADD IF NOT EXISTS " + "`" + columnName + "` " + type + " DEFAULT '" + defaultValue + "'";
        connection.prepareStatement(addColumn).execute();
    }

    private void dockedUpdate_2_4_99(Connection connect) throws SQLException {
        this.addColumn(connect, "port", "docked", "VARCHAR(1000)");
    }

    private void runTitleUpdate_2_5_99(Connection connect) throws SQLException {
        this.addColumn(connect, "test", "run_title", "VARCHAR(421844)", "");
    }
}

