/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.results.testdata.data.utils;

import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceConversionError;
import com.excentis.products.byteblower.results.testdata.data.utils.ConversionHelper;
import java.util.regex.Pattern;

public class MacAddressUtility {
    private MacAddressUtility() {
    }

    public static byte[] convertToBinary(String macAddressString) throws TestDataPersistenceConversionError {
        String delString = macAddressString.replaceAll("-", ":");
        String[] parts = Pattern.compile("\\:").split(delString);
        if (parts.length == 1) {
            if (parts[1].length() != 12) {
                throw new TestDataPersistenceConversionError("Cannot convert MAC address to binary; illegal address format '" + macAddressString + "' (need 12 chars for non-delimiter string");
            }
        } else if (parts.length == 6) {
            int i = 0;
            while (i < parts.length) {
                if (parts[i].length() != 2) {
                    throw new TestDataPersistenceConversionError("Cannot convert MAC address to binary;illegal address format '" + macAddressString + "' (need 6 x 2-char delimited groups)");
                }
                ++i;
            }
        } else {
            throw new TestDataPersistenceConversionError("Cannot convert MAC address to binary; illegal address format '" + macAddressString + "'");
        }
        String noDelString = delString.replaceAll(":", "");
        return ConversionHelper.hexStringToByteArray(noDelString);
    }

    public static String convertFromBinary(byte[] byteArray) throws TestDataPersistenceConversionError {
        if (byteArray.length != 6) {
            throw new TestDataPersistenceConversionError("Cannot convert MAC address from binary; illegal byte array '" + byteArray + "' (need 6 byte array");
        }
        String hexString = ConversionHelper.byteArrayToHexString(byteArray);
        hexString = hexString.replaceAll("..", "$0:");
        hexString = hexString.substring(0, hexString.length() - 1);
        return hexString;
    }
}

