/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run;

import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;

public class RuntimePreferences {
    private static final long DEFAULT_SCOUTING_INTERFRAME_GAP = 10000000L;
    private static final long MAXIMUM_UI_WAIT = 64L;
    private boolean enableScoutingFrames;
    private boolean identicalFramesWarning;
    private boolean ignoreInitializationError;
    private HighResolutionCalendar waitTimeAfterScenario;

    public RuntimePreferences(RuntimeScenario rtScenario) {
        ByteBlowerProject mProject = rtScenario.getModelScenario().getByteBlowerProject();
        this.enableScoutingFrames = mProject.isScenarioEnableScoutingFrames();
        this.identicalFramesWarning = mProject.isScenarioIdenticalFramesWarning();
        this.ignoreInitializationError = mProject.isScenarioIgnoreInitializationErrors();
        this.waitTimeAfterScenario = mProject.getScenarioWaitTimeAfterScenario();
    }

    public void setEnableScoutingFrames(boolean enableScoutingFrames) {
        this.enableScoutingFrames = enableScoutingFrames;
    }

    public boolean isEnableScoutingFrames() {
        return this.enableScoutingFrames;
    }

    public void setWaitTimeAfterScenario(HighResolutionCalendar waitTimeAfterScenario) {
        this.waitTimeAfterScenario = waitTimeAfterScenario;
    }

    public HighResolutionCalendar getWaitTimeAfterScenario() {
        return this.waitTimeAfterScenario;
    }

    public long getWaitTimeAfterScenarioNs() {
        return this.waitTimeAfterScenario.getTimeInNanoseconds();
    }

    public void setIdenticalFramesWarning(boolean identicalFramesWarning) {
        this.identicalFramesWarning = identicalFramesWarning;
    }

    public boolean isIdenticalFramesWarning() {
        return this.identicalFramesWarning;
    }

    public boolean isIgnoreInitializationError() {
        return this.ignoreInitializationError;
    }

    public void setIgnoreInitializationError(boolean ignoreInitializationError) {
        this.ignoreInitializationError = ignoreInitializationError;
    }

    public long getScoutingInterFrameGapNs() {
        return 10000000L;
    }

    public static long getResponsiveWait() {
        return 64L;
    }
}

