/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.run.RuntimePreferences;
import com.excentis.products.byteblower.run.actions.CleanupScenario;
import com.excentis.products.byteblower.run.actions.ExceptionCatcher;
import com.excentis.products.byteblower.run.actions.InitializeScenario;
import com.excentis.products.byteblower.run.actions.ProgressNotifier;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyError;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import org.eclipse.core.runtime.IProgressMonitor;

public class RuntimeScenarioRunner
extends RuntimeObject
implements Context.ICancelChecker {
    private final Context context;
    private final RuntimeByteBlower rtByteBlower;
    private final ProgressNotifier progressNotifier;
    private final Object runnerStateWaitObj = new Object();
    private State runnerState = State.CREATED;
    private RuntimeScenario rtScenario;
    private RuntimePreferences rtPreferences;

    public RuntimeScenarioRunner() {
        this.context = new Context(this);
        this.progressNotifier = this.context.addGlobalDecorator(ProgressNotifier.class);
        this.context.addGlobalDecorator(ExceptionCatcher.class);
        ByteBlower apiByteBlower = ByteBlower.InstanceGet();
        this.rtByteBlower = new RuntimeByteBlower(this, apiByteBlower);
    }

    public Context getContext() {
        return this.context;
    }

    public RuntimePreferences getRuntimePreferences() {
        return this.rtPreferences;
    }

    public RuntimeByteBlower getRuntimeByteBlower() {
        return this.rtByteBlower;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtScenario;
    }

    @Override
    public boolean isCancelled() {
        if (this.progressNotifier == null || this.progressNotifier.getProgressMonitor() == null) {
            return false;
        }
        return this.progressNotifier.getProgressMonitor().isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Scenario mScenario, String runTitle, IProgressMonitor progressMonitor) {
        Object object = this.runnerStateWaitObj;
        synchronized (object) {
            if (this.runnerState != State.CREATED) {
                throw new IllegalStateException("Cannot initialize scenario '" + mScenario.getName() + "'; when runner is in " + (Object)((Object)this.runnerState) + " state (expected " + (Object)((Object)State.CREATED) + ")");
            }
            this.runnerState = State.INITIALIZING;
        }
        this.rtScenario = new RuntimeScenario(this, mScenario, runTitle);
        this.rtPreferences = new RuntimePreferences(this.rtScenario);
        this.progressNotifier.setProgressMonitor(progressMonitor);
        AbstractAction init = InitializeScenario.create(this.context, this.rtScenario, progressMonitor);
        try {
            InitializeScenario.create(this.context, this.rtScenario, progressMonitor).invoke();
            Object object2 = this.runnerStateWaitObj;
            synchronized (object2) {
                this.runnerState = State.INITIALIZED;
            }
        }
        catch (Exception initEx) {
            this.finalCleanup(progressMonitor);
            throw new UserFriendlyError(init, (Throwable)initEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor progressMonitor) {
        Object object = this.runnerStateWaitObj;
        synchronized (object) {
            if (this.runnerState != State.INITIALIZED) {
                throw new IllegalStateException("Cannot run scenario '" + this.rtScenario.getName() + "'; when runner is in " + (Object)((Object)this.runnerState) + " state (expected " + (Object)((Object)State.INITIALIZED) + ")");
            }
            this.runnerState = State.RUNNING;
        }
        this.progressNotifier.setProgressMonitor(progressMonitor);
        try {
            RunScenario.create(this.context, this.rtScenario, progressMonitor).invoke();
        }
        finally {
            this.finalCleanup(progressMonitor);
        }
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalCleanup(IProgressMonitor progressMonitor) {
        if (this.runnerState == State.DONE) {
            return;
        }
        Context.CancelCheck previousState = Context.CancelCheck.CHECK;
        try {
            previousState = this.getContext().setCancelBehavior(Context.CancelCheck.DONT_CHECK);
            this.progressNotifier.setProgressMonitor(progressMonitor);
            CleanupScenario.create(this.context, this.rtByteBlower, this.rtScenario).invoke();
            Object object = this.runnerStateWaitObj;
            synchronized (object) {
                this.rtScenario = null;
                this.runnerState = State.DONE;
            }
        }
        finally {
            this.getContext().setCancelBehavior(previousState);
        }
    }

    private static enum State {
        CREATED,
        INITIALIZING,
        INITIALIZED,
        RUNNING,
        DONE;

    }
}

