/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.run.actions.ConfigureFlowApplications;
import com.excentis.products.byteblower.run.actions.ConfigureFlowEndPoints;
import com.excentis.products.byteblower.run.actions.ConfigureFlowTraffic;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;

public final class ConfigureFlow
extends ConcreteAction<Listener> {
    public static final int WORK = 2;
    private final RuntimeFlow rtFlow;
    private final FlowMeasurementReader mFlowInstanceReader;

    static AbstractAction create(Context context, RuntimeFlow rtFlow) {
        return context.decorate(new ConfigureFlow(context, rtFlow));
    }

    private ConfigureFlow(Context context, RuntimeFlow rtFlow) {
        super(context, Listener.class);
        this.rtFlow = rtFlow;
        this.mFlowInstanceReader = rtFlow.getModelFlowInstanceReader();
    }

    @Override
    public String getDescription() {
        return "Configure flow '" + this.mFlowInstanceReader.getFlowReader().getName() + "'";
    }

    @Override
    public void invokeImpl() {
        try {
            ConfigureFlowEndPoints.create(this.getContext(), this.rtFlow).invoke();
            ConfigureFlowApplications.create(this.getContext(), this.rtFlow).invoke();
            ConfigureFlowTraffic.create(this.getContext(), this.rtFlow).invoke();
            this.rtFlow.setState(RuntimeFlow.State.CONFIGURED);
            ((Listener)this.getListener()).onFlowConfigured(this.rtFlow);
        }
        catch (UserFriendlyInitializationError ufe) {
            this.rtFlow.setState(RuntimeFlow.State.FAILED);
            ((Listener)this.getListener()).onFlowConfigurationFailed(this.rtFlow, String.valueOf(ufe.toString()) + "\n" + ufe.getDetail());
            throw ufe;
        }
        catch (RuntimeDomainError rtde) {
            this.rtFlow.setState(RuntimeFlow.State.FAILED);
            ((Listener)this.getListener()).onFlowConfigurationFailed(this.rtFlow, rtde.getMessage());
            throw rtde;
        }
    }

    public static interface Listener {
        public void onFlowConfigured(RuntimeFlow var1);

        public void onFlowConfigurationFailed(RuntimeFlow var1, String var2);
    }
}

