/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.run.actions.ConfigureFlowApplicationsHttp;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;

final class ConfigureFlowApplications
extends ConcreteAction<Listener>
implements ConfigureFlowApplicationsHttp.Listener {
    private final RuntimeFlow rtFlow;

    static AbstractAction create(Context context, RuntimeFlow rtFlow) {
        return context.decorate(new ConfigureFlowApplications(context, rtFlow));
    }

    private ConfigureFlowApplications(Context context, RuntimeFlow rtFlow) {
        super(context, Listener.class);
        this.rtFlow = rtFlow;
    }

    @Override
    public String getDescription() {
        return "Configure applications for flow '" + this.rtFlow.name() + "'";
    }

    @Override
    public void invokeImpl() {
        if (this.rtFlow.getSourceRuntimePort().isMobile()) {
            RuntimeFlowDestination destination = this.rtFlow.getRuntimeFlowDestination();
            for (RuntimePort destPort : destination.getRuntimePorts()) {
                if (!destPort.isMobile()) continue;
                throw new IllegalStateException("Source and Destination ports can't be both Mobile Devices");
            }
        }
        switch (this.rtFlow.getType()) {
            case FB: {
                break;
            }
            case HTTP: {
                if (!(this.rtFlow instanceof RuntimeHttpFlow)) break;
                ConfigureFlowApplicationsHttp.create(this.getContext(), (RuntimeHttpFlow)this.rtFlow).invoke();
                break;
            }
        }
        ((Listener)this.getListener()).onFlowApplicationsConfigured(this.rtFlow);
    }

    static interface Listener {
        public void onFlowApplicationsConfigured(RuntimeFlow var1);
    }
}

