/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.VLANTag;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeInitializationError;
import com.excentis.products.byteblower.run.objects.RuntimeLayer25Configuration;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;

public final class ConfigureLayer25
extends ConcreteAction<Listener> {
    private final RuntimePort rtPort;
    private final ByteBlowerGuiPortReader mPortReader;

    private ConfigureLayer25(Context context, RuntimePort rtPort) {
        super(context, Listener.class);
        this.rtPort = rtPort;
        this.mPortReader = rtPort.getModelPortReader();
    }

    static AbstractAction create(Context context, RuntimePort rtPort) {
        return context.decorate(new ConfigureLayer25(context, rtPort));
    }

    @Override
    public String getDescription() {
        return "Configure layer 2.5 of '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        ByteBlowerPort apiPort = this.rtPort.getApiPort();
        if (this.mPortReader.getVlanStack() != null) {
            int VlanCount = 0;
            for (Vlan vlan : this.mPortReader.getVlanStack().getVlans()) {
                VLANTag apiVlanTag;
                try {
                    apiVlanTag = apiPort.Layer25VlanAdd();
                }
                catch (ConfigError configError) {
                    throw new RuntimeInitializationError(this.composeErrorMessage(VlanCount, vlan));
                }
                apiVlanTag.IDSet((int)vlan.getVlanId());
                apiVlanTag.PrioritySet((int)vlan.getPriorityCodePoint());
                apiVlanTag.DropEligibleSet(vlan.isDropEligible());
                apiVlanTag.ProtocolIDSet(vlan.getProtocolId());
                this.rtPort.addRuntimeLayer25Configuration(apiVlanTag, vlan);
                ++VlanCount;
            }
            if (!this.rtPort.isRuntimeLayer25Empty()) {
                ((Listener)this.getListener()).onLayer25Configured(IteratorUtils.toList(this.rtPort.layer25ConfigurationOuterIterator()));
            }
        }
    }

    private String composeErrorMessage(int addedVlanCount, Vlan failingVlan) {
        String errorMsg;
        String portName = this.mPortReader.getName();
        if (addedVlanCount > 0) {
            String errorFormat = "Port '%s' does not support adding an extra vlantag (id = %d). Vlantags %s were added";
            String addedIds = "";
            boolean first = true;
            int ctr = 0;
            while (ctr < addedVlanCount) {
                Vlan tag = (Vlan)this.mPortReader.getVlanStack().getVlans().get(ctr);
                if (first) {
                    first = false;
                } else {
                    addedIds = String.valueOf(addedIds) + ", ";
                }
                addedIds = String.valueOf(addedIds) + tag.getVlanId();
                ++ctr;
            }
            errorMsg = String.format(errorFormat, portName, failingVlan.getVlanId(), addedIds);
        } else {
            String errorFormat = "Port '%s' did not support adding vlantag %d";
            errorMsg = String.format(errorFormat, portName, failingVlan.getVlanId());
        }
        return errorMsg;
    }

    public static interface Listener {
        public void onLayer25Configured(List<RuntimeLayer25Configuration> var1);
    }
}

