/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.LatencyBasicMobile;
import com.excentis.products.byteblower.communication.api.LatencyDistributionMobile;
import com.excentis.products.byteblower.communication.api.TriggerBasicMobile;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimeMobileLatencyDistributionRx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileLatencyRx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileRx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.List;

public final class ConfigureMobileRx
extends ConcreteAction<Listener> {
    private final RuntimeFbFlow rtFbFlow;
    private final APIConfig api;
    private final RuntimeMobileDevice rxPort;
    private final long leadoutTime;

    static AbstractAction createRx(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        RxBasic action = new RxBasic(rtFbFlow, rtPort);
        return context.decorate(new ConfigureMobileRx(context, rtFbFlow, rtPort, action));
    }

    static AbstractAction createLatency(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        LatencyBasic action = new LatencyBasic(rtFbFlow, rtPort);
        return context.decorate(new ConfigureMobileRx(context, rtFbFlow, rtPort, action));
    }

    static AbstractAction createDistribution(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        LatencyDistribution action = new LatencyDistribution(rtFbFlow, rtPort);
        return context.decorate(new ConfigureMobileRx(context, rtFbFlow, rtPort, action));
    }

    private ConfigureMobileRx(Context context, RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort, APIConfig action) {
        super(context, Listener.class);
        this.rtFbFlow = rtFbFlow;
        this.rxPort = rtPort;
        this.leadoutTime = rtFbFlow.getRuntimeScenario().getRuntimeScenarioRunner().getRuntimePreferences().getWaitTimeAfterScenarioNs();
        this.api = action;
    }

    @Override
    public String getDescription() {
        return "Configure RX Mobile devices";
    }

    @Override
    public void invokeImpl() {
        FlowMeasurementReader flowModel = this.rtFbFlow.getModelFlowInstanceReader();
        List<RuntimeFrameTx> frames = this.rtFbFlow.getRuntimeFramesTx();
        if (frames.isEmpty()) {
            throw new IllegalStateException("The runtimeflow has no frames");
        }
        long durationNs = this.calculateFlowDuration(flowModel);
        this.api.configureDuration(durationNs);
        RuntimeFrameRx aFrame = this.anyFrame(frames);
        this.checkFrame(aFrame);
        String ipv4Src = aFrame.getSourceIpAddress();
        UDPPacket udp = (UDPPacket)aFrame.getLayer(BPFFilter.Proto.UDP);
        int udpSrc = udp.getSource();
        int udpDest = udp.getDestination();
        this.api.configureFilter(ipv4Src, udpSrc, udpDest);
        this.checkFrameList(frames, ipv4Src, udpSrc, udpDest);
        this.api.finish(this.rtFbFlow);
    }

    private long calculateFlowDuration(FlowMeasurementReader flowModel) {
        long flowDuration = flowModel.getDurationInNanoseconds() + this.leadoutTime;
        return Math.max(100000000L, flowModel.getStartTimeInNanoseconds() + flowDuration);
    }

    private RuntimeFrameRx anyFrame(List<RuntimeFrameTx> frames) {
        RuntimeFrameTx first = frames.get(0);
        return first.getRuntimeFrameRx(this.rxPort);
    }

    private void checkFrame(RuntimeFrame frame) throws IllegalStateException {
        boolean isGood;
        boolean bl = isGood = (frame.hasIPv6Header() || frame.hasIPv4Header()) && BPFFilter.Proto.UDP.equals((Object)frame.getHighestProtocol());
        if (!isGood) {
            throw new IllegalStateException("Frame can not be filtered");
        }
    }

    private void checkFrameList(List<RuntimeFrameTx> frames, String ipv4Src, int updSrc, int updDest) {
        for (RuntimeFrameTx frame : frames) {
            boolean good;
            RuntimeFrameRx rxFrame = frame.getRuntimeFrameRx(this.rxPort);
            this.checkFrame(rxFrame);
            String frameIpv4Src = rxFrame.getSourceIpAddress();
            UDPPacket udp = (UDPPacket)rxFrame.getLayer(BPFFilter.Proto.UDP);
            int frameUdpSrc = udp.getSource();
            int frameUdpDest = udp.getDestination();
            boolean bl = good = ipv4Src.equals(frameIpv4Src) && updSrc == frameUdpSrc && updDest == frameUdpDest;
            if (good) continue;
            throw new IllegalStateException("Different frames, can't compose filter for mobile device.");
        }
    }

    private static interface APIConfig {
        public void configureFilter(String var1, int var2, int var3);

        public void configureDuration(long var1);

        public void finish(RuntimeFbFlow var1);
    }

    private static class LatencyBasic
    implements APIConfig {
        private final RuntimeMobileLatencyRx mobileLatency;

        public LatencyBasic(RuntimeFbFlow flow, RuntimeMobileDevice rtPort) {
            this.mobileLatency = new RuntimeMobileLatencyRx(flow, rtPort);
        }

        @Override
        public void configureFilter(String ipv4Src, int udpSrc, int udpDest) {
            LatencyBasicMobile apiRx = this.mobileLatency.getApi();
            apiRx.FilterSourceAddressSet(ipv4Src);
            apiRx.FilterUdpSourcePortSet(udpSrc);
            apiRx.FilterUdpDestinationPortSet(udpDest);
        }

        @Override
        public void configureDuration(long durationNs) {
            LatencyBasicMobile apiRx = this.mobileLatency.getApi();
            apiRx.DurationSet(durationNs);
        }

        @Override
        public void finish(RuntimeFbFlow flow) {
            flow.addRuntimeReceiver(this.mobileLatency);
        }
    }

    private static class LatencyDistribution
    implements APIConfig {
        private final RuntimeMobileLatencyDistributionRx mobileDistribution;
        private final long minRangeNs;
        private final long maxRangeNs;

        public LatencyDistribution(RuntimeFbFlow flow, RuntimeMobileDevice rtPort) {
            ByteBlowerProjectReader mProjectReader = ReaderFactory.create((ByteBlowerProject)flow.getRuntimeScenario().getModelScenario().getByteBlowerProject());
            this.mobileDistribution = new RuntimeMobileLatencyDistributionRx(flow, rtPort);
            this.minRangeNs = mProjectReader.getLatencyDistributionRangeStartNs();
            this.maxRangeNs = mProjectReader.getLatencyDistributionRangeEndNs();
        }

        @Override
        public void configureFilter(String ipv4Src, int udpSrc, int udpDest) {
            LatencyDistributionMobile apiRx = this.mobileDistribution.getApi();
            apiRx.FilterSourceAddressSet(ipv4Src);
            apiRx.FilterUdpSourcePortSet(udpSrc);
            apiRx.FilterUdpDestinationPortSet(udpDest);
        }

        @Override
        public void configureDuration(long durationNs) {
            LatencyDistributionMobile apiRx = this.mobileDistribution.getApi();
            apiRx.DurationSet(durationNs);
            apiRx.RangeSet(this.minRangeNs, this.maxRangeNs);
        }

        @Override
        public void finish(RuntimeFbFlow flow) {
            flow.addRuntimeReceiver(this.mobileDistribution);
        }
    }

    public static interface Listener {
    }

    private static class RxBasic
    implements APIConfig {
        private final RuntimeMobileRx mobileRx;

        public RxBasic(RuntimeFbFlow flow, RuntimeMobileDevice rtPort) {
            this.mobileRx = new RuntimeMobileRx(flow, (RuntimePort)rtPort);
        }

        @Override
        public void configureFilter(String ipv4Src, int udpSrc, int udpDest) {
            TriggerBasicMobile apiRx = this.mobileRx.getApi();
            apiRx.FilterSourceAddressSet(ipv4Src);
            apiRx.FilterUdpSourcePortSet(udpSrc);
            apiRx.FilterUdpDestinationPortSet(udpDest);
        }

        @Override
        public void configureDuration(long durationNs) {
            TriggerBasicMobile apiRx = this.mobileRx.getApi();
            apiRx.DurationSet(durationNs);
        }

        @Override
        public void finish(RuntimeFbFlow flow) {
            flow.addRuntimeReceiver(this.mobileRx);
        }
    }
}

