/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.ByteBlowerPort;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.run.actions.ConfigureLayer2;
import com.excentis.products.byteblower.run.actions.ConfigureLayer25;
import com.excentis.products.byteblower.run.actions.ConfigureLayer3;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.exceptions.UserFriendlyError;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ConfigurePort
extends ConcreteAction<Listener> {
    public static final int WORK = 2;
    private final RuntimePort rtPort;

    public static AbstractAction create(Context context, RuntimePort rtPort) {
        return context.decorate(new ConfigurePort(context, rtPort));
    }

    private ConfigurePort(Context context, RuntimePort rtPort) {
        super(context, Listener.class);
        this.rtPort = rtPort;
    }

    @Override
    public String getDescription() {
        return "Configure port '" + this.rtPort.getName() + "'";
    }

    @Override
    public void invokeImpl() {
        try {
            if (this.rtPort.getState() == RuntimePort.State.CREATED) {
                this.configure();
                this.rtPort.setState(RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC);
            } else if (this.rtPort.getState() == RuntimePort.State.CONFIGURED_AND_WAITING_FOR_ASYNC) {
                this.waitForAsync();
                this.rtPort.setState(RuntimePort.State.CONFIGURED);
                ((Listener)this.getListener()).onPortConfigured(this.rtPort);
            }
        }
        catch (UserFriendlyError ufe) {
            this.rtPort.setState(RuntimePort.State.FAILED);
            ((Listener)this.getListener()).onPortConfigurationFailed(this.rtPort, ufe.toString());
            throw ufe;
        }
        catch (RuntimeDomainError rtde) {
            this.rtPort.setState(RuntimePort.State.FAILED);
            ((Listener)this.getListener()).onPortConfigurationFailed(this.rtPort, rtde.getMessage());
            throw rtde;
        }
    }

    private void configure() {
        ConfigureLayer2.create(this.getContext(), this.rtPort).invoke();
        ConfigureLayer25.create(this.getContext(), this.rtPort).invoke();
        this.setMDL();
        ConfigureLayer3.create(this.getContext(), this.rtPort).invoke();
    }

    private void waitForAsync() {
        ConfigureLayer3.create(this.getContext(), this.rtPort).invoke();
    }

    private void setMDL() {
        ByteBlowerPort apiPort = this.rtPort.getApiPort();
        long mtu = this.rtPort.getModelPort().getMtu();
        long dataLinkOverhead = this.rtPort.getLayer2OverheadSize() + this.rtPort.getLayer25OverheadSize();
        try {
            apiPort.MDLSet(mtu + dataLinkOverhead);
        }
        catch (ConfigError apiConfigError) {
            long maximumMdl = apiPort.MDLMaximumGet();
            throw new RuntimeDomainError("MTU " + mtu + " is above supported maximum " + (maximumMdl - dataLinkOverhead) + " for this port", apiConfigError);
        }
    }

    public static interface Listener {
        public void onPortConfiguring(RuntimePort var1);

        public void onPortConfigured(RuntimePort var1);

        public void onPortConfigurationFailed(RuntimePort var1, String var2);
    }
}

