/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import java.util.List;

public final class CreateFlows
extends ConcreteAction<Listener> {
    private final RuntimeScenario rtScenario;

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new CreateFlows(context, rtScenario));
    }

    private CreateFlows(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
    }

    @Override
    public String getDescription() {
        return "Create flows";
    }

    @Override
    public void invokeImpl() {
        ScenarioReader scenarioReader = this.rtScenario.getModelScenarioReader();
        List flowInstances = scenarioReader.getSortedFlowMeasurements();
        for (FlowMeasurement mFlowInstance : flowInstances) {
            this.processFlow(mFlowInstance);
        }
        ((Listener)this.getListener()).onFlowsCreated(this.rtScenario);
    }

    private void processFlow(FlowMeasurement mFlowInstance) {
        CreateFlow.create(this.getContext(), this.rtScenario, mFlowInstance).invoke();
    }

    public static interface Listener {
        public void onFlowsCreated(RuntimeScenario var1);
    }
}

