/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.run.actions.CreateMeetingPoint;
import com.excentis.products.byteblower.run.actions.CreateServer;
import com.excentis.products.byteblower.run.actions.ServerTimeSynchronization;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeBBServer;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeMeetingPoint;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public final class CreateServers
extends ConcreteAction<Listener>
implements CreateServer.Listener,
CreateMeetingPoint.Listener {
    private final RuntimeScenario rtScenario;
    private final RuntimeByteBlower rtByteBlower;
    private List<RuntimeServer> servers = new ArrayList<RuntimeServer>();

    static AbstractAction create(Context context, RuntimeScenario rtScenario) {
        return context.decorate(new CreateServers(context, rtScenario));
    }

    private CreateServers(Context context, RuntimeScenario rtScenario) {
        super(context, Listener.class);
        this.rtScenario = rtScenario;
        this.rtByteBlower = rtScenario.getRuntimeByteBlower();
    }

    @Override
    public String getDescription() {
        return "Create servers";
    }

    @Override
    public void invokeImpl() {
        this.getContext().listen(CreateServer.Listener.class, this);
        this.getContext().listen(CreateMeetingPoint.Listener.class, this);
        ScenarioReader scenarioReader = this.rtScenario.getModelScenarioReader();
        EList usedServers = scenarioReader.getInvolvedServers();
        for (ScenarioReader.ServerDescription servers : usedServers) {
            this.processServer(servers);
        }
        for (RuntimeServer server : this.servers) {
            ServerTimeSynchronization.create(this.getContext(), server).invoke();
        }
        ((Listener)this.getListener()).onServersCreated(this.rtScenario);
    }

    private void processServer(ScenarioReader.ServerDescription server) {
        String serverUrl = server.getNetworkAddress();
        switch (server.getType()) {
            case BYTE_BLOWER: {
                RuntimeBBServer rtServer = this.rtByteBlower.findRuntimeBBServerOnURL(serverUrl);
                if (rtServer != null) break;
                CreateServer.create(this.getContext(), this.rtByteBlower, serverUrl).invoke();
                break;
            }
            case MEETING_POINT: {
                RuntimeMeetingPoint rtServer = this.rtByteBlower.findRuntimeMeetingPointOnURL(server.getNetworkAddress());
                if (rtServer != null) break;
                CreateMeetingPoint.create(this.getContext(), this.rtByteBlower, serverUrl).invoke();
                break;
            }
            default: {
                throw new RuntimeException("Unkown server type");
            }
        }
    }

    @Override
    public void onServerCreated(RuntimeBBServer server) {
        this.servers.add(server);
    }

    @Override
    public void onServerCreationFailed(String serverUrl, CreateServer.Listener.ErrorType errorType, String errorMessage) {
    }

    @Override
    public void onMeetingPointCreated(RuntimeMeetingPoint rtServer) {
        this.servers.add(rtServer);
    }

    public static interface Listener {
        public void onServersCreated(RuntimeScenario var1);
    }
}

