/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions;

import com.excentis.products.byteblower.communication.api.AddressResolutionFailed;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.run.actions.core.AbstractAction;
import com.excentis.products.byteblower.run.actions.core.ConcreteAction;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public final class ResolveMacAddress
extends ConcreteAction<Listener> {
    private final RuntimePort resolver;
    private final String ipAddress;

    static AbstractAction create(Context context, RuntimePort resolver, String ipAddress) {
        return context.decorate(new ResolveMacAddress(context, resolver, ipAddress));
    }

    private ResolveMacAddress(Context context, RuntimePort resolver, String ipAddress) {
        super(context, Listener.class);
        this.resolver = resolver;
        this.ipAddress = ipAddress;
    }

    @Override
    public String getDescription() {
        if (this.resolver != null) {
            if (this.ipAddress != null) {
                return "Address resolution by port '" + this.resolver.getName() + "' for IP " + this.ipAddress;
            }
            return "Address resolution by port '" + this.resolver.getName() + "'";
        }
        return "Address resolution";
    }

    @Override
    public void invokeImpl() {
        try {
            String macAddress = this.resolver.resolve(this.ipAddress);
            ((Listener)this.getListener()).onMacAddressResolved(this.resolver, this.ipAddress, macAddress);
        }
        catch (AddressResolutionFailed | ConfigError bbEx) {
            ((Listener)this.getListener()).onMacAddressResolveFailed(this.resolver, this.ipAddress);
            throw bbEx;
        }
    }

    public static interface Listener {
        public void onMacAddressResolved(RuntimePort var1, String var2, String var3);

        public void onMacAddressResolveFailed(RuntimePort var1, String var2);
    }
}

